/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QualifiedSelectorCompletionContributor
extends OCCompletionContributorBase {
    public QualifiedSelectorCompletionContributor() {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withParent(OCQualifiedExpression.class), new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                OCQualifiedExpression expr = (OCQualifiedExpression)parameters.getPosition().getParent();
                OCObjectTypeContext typeContext = expr.getQualifier().getTypeContext();
                int invocationCount = Integer.MAX_VALUE;
                for (OCPunctuatorElementType qt : expr.qualifyingTokensForCompletion()) {
                    int ic = this.addCompletions(qt, parameters, result, expr, typeContext);
                    invocationCount = Math.min(invocationCount, ic);
                }
                if (typeContext != null && invocationCount <= 1) {
                    result.addLookupAdvertisement("Press " + QualifiedSelectorCompletionContributor.getActionShortcut((String)"SmartTypeCompletion") + " to filter results by type");
                    result.addLookupAdvertisement("Press " + QualifiedSelectorCompletionContributor.getActionShortcut((String)"CodeCompletion") + (invocationCount == 0 ? "" : " again") + " for symbols from NSObject categories");
                }
            }

            private int addCompletions(@NotNull OCPunctuatorElementType qualifyingToken, final @NotNull OCCompletionParameters parameters, CompletionResultSet result, OCQualifiedExpression expr, OCObjectTypeContext typeContext) {
                int i;
                CommonProcessors.CollectProcessor<OCSymbol> symbols = new CommonProcessors.CollectProcessor<OCSymbol>(){
                    private Set<String> names = new HashSet<String>();
                    private Map<String, OCSymbol> members = new HashMap<String, OCSymbol>();

                    public boolean process(OCSymbol symbol) {
                        OCFile file;
                        PsiElement fragmentContext;
                        if (symbol.getKind().isType() || symbol.isUnnamed()) {
                            return true;
                        }
                        PsiFile original = parameters.getOriginalFile();
                        Project project2 = original.getProject();
                        if (original instanceof OCCodeFragment && (fragmentContext = original.getContext()) != null) {
                            original = fragmentContext.getContainingFile().getOriginalFile();
                        }
                        if (!(original instanceof OCFile && OCFileSymbols.isSymbolImported((OCFile)original, symbol) || (file = symbol.getContainingOCFile(project2)) == null || file.isHeader())) {
                            return true;
                        }
                        if (symbol.getKind().isConstructorOrDestructor()) {
                            return true;
                        }
                        if (symbol instanceof OCFunctionSymbol || symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                            String name2 = symbol.getName();
                            OCSymbolWithQualifiedName symbolParent = ((OCSymbolWithQualifiedName)symbol).getParent();
                            if (symbolParent == null) {
                                return super.process((Object)symbol);
                            }
                            if (this.members.containsKey(name2)) {
                                OCSymbol parent = this.members.get(name2);
                                if (parent.equals(symbolParent)) {
                                    return super.process((Object)symbol);
                                }
                                return true;
                            }
                            this.members.put(name2, symbolParent);
                            return super.process((Object)symbol);
                        }
                        if (this.names.add(symbol.getSignature(project2))) {
                            return super.process((Object)symbol);
                        }
                        return true;
                    }
                };
                OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)symbols, (Condition<T>[])new Condition[]{symbol -> symbol.getKind() == OCSymbolKind.PROPERTY, symbol -> symbol instanceof OCMethodSymbol && symbol.isPredeclaration(), symbol -> symbol.getKind().isFunction(), symbol -> !symbol.getKind().isConstructorOrDestructor(), OCSymbol.NON_FANTOM_SYMBOL_CONDITION});
                Ref qualifierType = new Ref();
                expr.processTargets(null, orderedProcessor, false, qualifyingToken, false, true, (Ref<OCType>)qualifierType, OCResolveContext.forPsi(expr));
                orderedProcessor.finish();
                if (qualifierType.isNull()) {
                    qualifierType.set((Object)expr.getQualifier().getResolvedType());
                }
                for (i = parameters.getInvocationCount(); i <= 2; ++i) {
                    boolean isEmpty = true;
                    for (OCSymbol symbol2 : symbols.getResults()) {
                        boolean isFromCurClass = false;
                        if (symbol2 instanceof OCMemberSymbol) {
                            OCClassSymbol parent = ((OCMemberSymbol)symbol2).getParent();
                            if (i <= 1 && "NSObject".equals(parent.getName()) && parent.getCategoryName() != null) continue;
                            boolean bl = isFromCurClass = typeContext != null && Comparing.equal((String)parent.getName(), (String)typeContext.getType().getClassName());
                        }
                        if (symbol2.isUnavailable() || symbol2.isForbiddenByARC(expr) || i <= 1 && !OCVisibility.isVisible(symbol2, expr, (OCType)qualifierType.get(), expr.getProject()) || symbol2 instanceof OCMethodSymbol && symbol2.isSynthetic() && !((OCMethodSymbol)symbol2).isAccessorWithAliasedName(expr.getProject())) continue;
                        LookupElement lookup = SymbolLookupBuilderUtil.lookup(symbol2, null, typeContext != null ? typeContext.getType() : null, expr, isFromCurClass, null, expr.getProject());
                        if (!result.getPrefixMatcher().prefixMatches(lookup)) continue;
                        result.addElement(lookup);
                        OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.set((UserDataHolder)lookup, (Object)qualifyingToken);
                        isEmpty = false;
                    }
                    if (!isEmpty) break;
                }
                return i;
            }
        });
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof OCQualifiedExpression) {
            OCQualifiedExpression expr = (OCQualifiedExpression)parent;
            OCType resolve2 = expr.getQualifier().getResolvedType(OCResolveContext.forPsi(expr));
            if (resolve2.getTerminalType() instanceof OCObjectType) {
                return "No suggestions for properties of class " + resolve2.getTerminalType().getName(expr);
            }
            return "No suggestions for members of " + resolve2.getName(expr);
        }
        return super.handleEmptyLookup(parameters, editor);
    }
}

