/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPRightSideTypeMacro
extends Macro {
    public static final String MACRO_NAME = "rightSideType";

    public String getName() {
        return MACRO_NAME;
    }

    public String getPresentableName() {
        return "rightSideType()";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        OCType type;
        OCExpression initializer;
        List<OCDeclarator> declarators;
        Project project2 = context.getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
        if (OCCompilerFeatures.supportsCxxAutoType(file)) {
            return new TextResult("auto");
        }
        int offset = context.getStartOffset();
        PsiElement currentElement = file.findElementAt(offset);
        OCDeclaration declaration = CPPRightSideTypeMacro.findParentDeclaration(currentElement);
        if (declaration != null && !(declarators = declaration.getDeclarators()).isEmpty() && (initializer = declarators.get(0).getInitializer()) != null && !(type = initializer.getResolvedType()).isUnresolved(declaration)) {
            String result = type.getBestNameInContext(declaration);
            return new TextResult(result);
        }
        return null;
    }

    private static OCDeclaration findParentDeclaration(PsiElement element) {
        while (!(element instanceof OCTypeElement)) {
            if ((element = element.getParent()) != null && !(element instanceof OCLocalScopeable)) continue;
            return null;
        }
        if (element.getParent() instanceof OCDeclaration) {
            return (OCDeclaration)element.getParent();
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

