/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCElementResult;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import icons.CidrLangIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFastEnumerationVariableMacro
extends Macro {
    public String getName() {
        return "fastEnumeration";
    }

    public String getPresentableName() {
        return "fastEnumeration()";
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement[] variables = OCFastEnumerationVariableMacro.getVariables(params, context);
        if (variables == null || variables.length == 0) {
            return null;
        }
        return new OCElementResult((OCElement)variables[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement[] variables = OCFastEnumerationVariableMacro.getVariables(params, context);
        if (variables == null || variables.length < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            PsiElement var = variables[i];
            items[i] = var instanceof PsiNamedElement ? LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)var)).withIcon(var.getIcon(0)) : LookupElementBuilder.create((String)var.getText()).withIcon(CidrLangIcons.CodeAssistantMember);
        }
        return items;
    }

    @Nullable
    protected static PsiElement[] getVariables(Expression[] params, ExpressionContext context) {
        if (params.length != 0) {
            return null;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file = place.getContainingFile();
        assert (file != null);
        OCType enums = OCReferenceType.resolvedFromText("id", "NSFastEnumeration", place);
        OCPointerType maps = OCPointerType.to(OCReferenceType.resolvedFromText("NSDictionary", (PsiElement)file));
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, false);
        for (OCDeclaratorSymbol var : variables) {
            PsiElement parent;
            PsiElement def;
            OCType type = OCFastEnumerationVariableMacro.getGuessedType(var, file);
            OCResolveContext resolveContext = OCResolveContext.forPsi(place);
            if (!type.isPointerToObject() || !enums.isCompatible(type, resolveContext) || (def = var.locateDefinition(context.getProject())) == null || (parent = def.getParent().getParent()) instanceof OCForeachStatement) continue;
            result.add(def);
            if (type.isPointerToID() || !maps.isCompatible(type, resolveContext)) continue;
            result.add(OCElementFactory.expressionFromText("[" + var.getName() + " allKeys]", (PsiElement)file));
            result.add(OCElementFactory.expressionFromText("[" + var.getName() + " allValues]", (PsiElement)file));
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    private static OCType getGuessedType(OCDeclaratorSymbol var, @NotNull PsiFile file) {
        OCExpression initializer;
        PsiElement def;
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
        OCType basic = var.getResolvedType(context);
        if (basic.isPointerToID() && var.getKind() == OCSymbolKind.LOCAL_VARIABLE && (def = var.locateDefinition(context.getProject())) instanceof OCDeclarator && (initializer = ((OCDeclarator)def).getInitializer()) != null) {
            return initializer.getResolvedType().getGuessedType();
        }
        return basic;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

