/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class OCSuggestVariableNameMacro
extends Macro {
    public String getName() {
        return "suggestVariableName";
    }

    public String getPresentableName() {
        return "suggestVariableName()";
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        Collection<String> names = OCSuggestVariableNameMacro.getNames(context);
        return names.isEmpty() ? null : new TextResult(names.iterator().next());
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        Collection<String> names = OCSuggestVariableNameMacro.getNames(context);
        if (names.size() < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[names.size()];
        int i = 0;
        for (String name2 : names) {
            items[i++] = LookupElementBuilder.create((Object)name2, (String)name2);
        }
        return items;
    }

    private static Collection<String> getNames(ExpressionContext context) {
        Collection<String> names = OCTemplatesUtil.getNames(context);
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        names = new LinkedHashSet<String>(names);
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        String safeName = place.getText();
        Iterator<String> it = names.iterator();
        String firstNotUnique = null;
        while (it.hasNext()) {
            String name2 = it.next();
            if (name2.equals(safeName) || OCCodeInsightUtil.isUniqueInScope(null, name2, place, context.getProject())) continue;
            it.remove();
            if (firstNotUnique != null) continue;
            firstNotUnique = name2;
        }
        if (names.isEmpty()) {
            return Collections.singleton(OCNameSuggester.suggestUniqueName(null, firstNotUnique, place, context.getProject()));
        }
        return names;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

