/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class AfterSemicolonEnterProcessor
extends SmartEnterProcessorWithFixers.FixEnterProcessor {
    public boolean doEnter(@NotNull PsiElement atCaret, @NotNull PsiFile file, @NotNull Editor editor, boolean modified) {
        if (atCaret instanceof OCExpressionStatement || atCaret instanceof OCDeclarationStatement || atCaret instanceof OCDeclaration && !(atCaret instanceof OCFunctionDefinition) || atCaret instanceof OCReturnStatement || atCaret instanceof OCBreakStatement || atCaret instanceof OCContinueStatement || atCaret instanceof OCCppNamespaceAlias || atCaret instanceof OCCppUsingStatement || atCaret instanceof OCMethod && ((OCMethod)atCaret).getContainingClass() instanceof OCInterface) {
            PsiErrorElement error = OCFixer.getErrorElementOffset(atCaret);
            int errorOffset = error == null ? -1 : error.getTextOffset();
            int elementEndOffset = OCFixer.getRangeWithMacros(atCaret).getEndOffset();
            CharSequence text = editor.getDocument().getCharsSequence();
            if (errorOffset >= 0 && errorOffset < elementEndOffset) {
                if (OCElementUtil.isErrorWithTextAtEnd((PsiElement)error, "Expecting '{'") || OCElementUtil.isErrorWithTextAtEnd((PsiElement)error, "} expected")) {
                    return modified;
                }
                if (text.charAt(errorOffset) == ' ' && text.charAt(errorOffset + 1) == ';') {
                    ++errorOffset;
                }
            } else if (elementEndOffset < text.length() && text.charAt(elementEndOffset) == ';') {
                ++elementEndOffset;
            }
            editor.getCaretModel().moveToOffset(errorOffset >= 0 ? errorOffset : elementEndOffset);
            return modified;
        }
        return false;
    }
}

