/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.DoWhileConditionFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppStaticAssert;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemicolonFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        OCReturnStatement stmt;
        OCCallable method;
        if (TreeUtil.findParent((ASTNode)psiElement.getNode(), (IElementType)OCElementTypes.MACRO_CALL) != null) {
            return;
        }
        if (psiElement instanceof OCReturnStatement && (method = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{OCMethod.class, OCFunctionDefinition.class})) != null && method.getReturnType().isVoid() && (stmt = (OCReturnStatement)psiElement).getExpression() != null && !SemicolonFixer.hasMacroBasedStatement(stmt, OCTokenTypes.RETURN_KEYWORD)) {
            Document doc = editor.getDocument();
            doc.insertString(SemicolonFixer.getRangeWithMacros(stmt).getStartOffset() + "return".length(), (CharSequence)";");
            return;
        }
        if (SemicolonFixer.canNeedSemicolon(psiElement)) {
            ASTNode typeDef;
            PsiElement parent;
            if (psiElement instanceof OCDeclarationStatement && psiElement.getParent() instanceof OCCondition) {
                psiElement = psiElement.getParent();
            }
            if ((parent = psiElement.getParent()) instanceof OCStatementWithExpression || parent instanceof OCIfStatement || parent instanceof OCDeclaration && SemicolonFixer.hasIncompleteStructInType(parent.getNode().findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT)) || parent instanceof OCTypeElement && SemicolonFixer.hasIncompleteStructInType(parent.getNode())) {
                return;
            }
            if (psiElement instanceof OCStructLike && (typeDef = TreeUtil.findParent((ASTNode)psiElement.getNode(), (IElementType)OCElementTypes.DECLARATION)) != null) {
                psiElement = typeDef.getPsi();
            }
            SemicolonFixer.fixSemicolonAtTheEnd(editor, psiElement);
        }
    }

    private static boolean canNeedSemicolon(@NotNull PsiElement psiElement) {
        if (psiElement instanceof OCDoWhileStatement) {
            return DoWhileConditionFixer.applicable(psiElement);
        }
        if (psiElement instanceof OCStructLike) {
            return SemicolonFixer.isRealLeafElement(((OCStructLike)psiElement).getOpeningBrace()) && SemicolonFixer.isRealLeafElement(((OCStructLike)psiElement).getClosingBrace());
        }
        if (psiElement instanceof OCMethod) {
            return ((OCMethod)psiElement).getContainingClass() instanceof OCInterface;
        }
        return OCElementUtil.isMissingSemicolonError(psiElement) || psiElement instanceof OCExpressionStatement || psiElement instanceof OCDeclarationStatement || psiElement instanceof OCReturnStatement || psiElement instanceof OCBreakStatement || psiElement instanceof OCContinueStatement || psiElement instanceof OCCppNamespaceAlias || psiElement instanceof OCCppUsingStatement || psiElement instanceof OCCppStaticAssert;
    }

    @Contract(value="null -> false")
    private static boolean hasIncompleteStructInType(@Nullable ASTNode type) {
        if (type == null) {
            return false;
        }
        ASTNode structLike = type.findChildByType(OCElementTypes.STRUCTURE_TYPES);
        return structLike != null && SemicolonFixer.isIncompleteStruct(structLike.getPsi());
    }

    private static boolean isIncompleteStruct(@NotNull PsiElement structLikePsi) {
        return structLikePsi instanceof OCStructLike && !SemicolonFixer.isLikeStructVarDeclaration(structLikePsi) && ((OCStructLike)structLikePsi).getOpeningBrace() == null && ((OCStructLike)structLikePsi).getClosingBrace() == null;
    }
}

