/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCExpressionTrimRenderer;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCIfRespondsToSurrounder
extends OCStatementSurrounder<OCIfStatement> {
    private static final NotNullFunction<PsiElement, TextRange> RANGER = dom -> OCElementUtil.getRangeWithMacros(dom);

    @Override
    protected String getStatementTemplate(Project project2, PsiElement context) {
        return "if ([x respondsToSelector:@selector(selector)]) {\n}";
    }

    @Override
    public TextRange surroundElements(final @NotNull Project project2, @NotNull Editor editor, final @NotNull PsiElement[] elements) throws IncorrectOperationException {
        final List<OCSendMessageExpression> sendMessageExprs = OCIfRespondsToSurrounder.findSendMessageExprs(elements);
        if (sendMessageExprs.size() == 1 || ApplicationManager.getApplication().isUnitTestMode() && !sendMessageExprs.isEmpty()) {
            return this.doSurroundElements(project2, elements, 0);
        }
        if (!sendMessageExprs.isEmpty()) {
            editor.getCaretModel().moveToOffset(elements[elements.length - 1].getTextOffset());
            IntroduceTargetChooser.showChooser((Editor)editor, sendMessageExprs, (Pass)new Pass<OCSendMessageExpression>(){

                public void pass(OCSendMessageExpression expr) {
                    WriteCommandAction.writeCommandAction((Project)project2).run(() -> OCIfRespondsToSurrounder.this.doSurroundElements(project2, elements, sendMessageExprs.indexOf(expr)));
                }
            }, new OCExpressionTrimRenderer.RenderFunction(), (String)"Expressions", RANGER);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"No send message expressions in the selected code", (String)this.getTemplateDescription(), null);
        }
        return elements[0].getTextRange();
    }

    @Override
    protected void insertOldElements(PsiElement[] elements, PsiElement container, OCIfStatement newStatement, @NotNull Object chosenElement) {
        OCSendMessageExpression sendMessageExpr = chosenElement instanceof OCSendMessageExpression ? (OCSendMessageExpression)chosenElement : OCIfRespondsToSurrounder.findSendMessageExprs(elements).get((Integer)chosenElement);
        OCSendMessageExpression ifMessageExpr = (OCSendMessageExpression)newStatement.getCondition().getExpression();
        OCReferenceExpression ifReceiver = (OCReferenceExpression)ifMessageExpr.getReceiverExpression();
        OCExpression receiver = sendMessageExpr.getReceiverExpression();
        ((OCSelectorExpression)ifMessageExpr.getArgumentExpressions().get(0)).getReference().handleElementRename(sendMessageExpr.getMessageSelector());
        if (receiver instanceof OCReferenceExpression) {
            ifReceiver.getReferenceElement().setNameOfIdentifier(((OCReferenceExpression)receiver).getReferenceElement().getName());
        } else if (receiver != null) {
            Collection<String> names = OCNameSuggester.suggestForExpression(OCSymbolKind.LOCAL_VARIABLE, receiver);
            String name2 = names.isEmpty() ? "x" : names.iterator().next();
            ifReceiver.getReferenceElement().setNameOfIdentifier(name2);
            OCDeclarationStatement declStmt = OCElementFactory.declarationStatement(name2, receiver.getResolvedType(), receiver, newStatement);
            OCChangeUtil.addBefore(container, declStmt, newStatement);
            OCChangeUtil.replaceHandlingMacros(receiver, OCElementFactory.expressionFromText(name2, newStatement));
        }
        super.insertOldElements(elements, container, newStatement, chosenElement);
    }

    private static List<OCSendMessageExpression> findSendMessageExprs(PsiElement[] elements) {
        final ArrayList<OCSendMessageExpression> result = new ArrayList<OCSendMessageExpression>();
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitSendMessageExpression(OCSendMessageExpression expression) {
                    OCSendMessageExpression.ProbableResponders responders = expression.getProbableResponders();
                    OCMethodSymbol responder = responders.getKnownResponder();
                    if (responder == null || responder.isOptional() || !responder.getParent().getName().equals("NSObject") || responder.getParent().getCategoryName() != null) {
                        result.add(expression);
                    }
                    super.visitSendMessageExpression(expression);
                }
            });
        }
        return result;
    }

    @Override
    protected PsiElement getInsertionPlace(OCIfStatement statement2) {
        return statement2.getThenBranch();
    }

    @Override
    protected TextRange getSelectionRange(OCIfStatement statement2) {
        int offset = statement2.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return "if respondsToSelector";
    }

    @Override
    protected OCLanguageKind getLanguageKind() {
        return CLanguageKind.OBJ_C;
    }
}

