/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.surround.OCSurroundUtil;
import com.jetbrains.cidr.lang.editor.surround.OCSurrounder;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OCStatementSurrounder<T extends OCStatement>
extends OCSurrounder {
    OCStatementSurrounder() {
    }

    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        return this.doSurroundElements(project2, elements, null);
    }

    public TextRange doSurroundElements(Project project2, PsiElement[] elements, @Nullable Object chosenElement) {
        PsiElement container = elements[0].getParent();
        if ((elements = OCSurroundUtil.moveDeclarationsOut(container, elements, true)).length == 0) {
            return null;
        }
        Object newStatement = this.upcast(OCElementFactory.statementFromText(this.getStatementTemplate(project2, elements[0]), container));
        newStatement = this.upcast((OCStatement)container.addBefore(newStatement, elements[0]));
        CodeStyleManager csManager = CodeStyleManager.getInstance((Project)project2);
        newStatement = this.upcast((OCStatement)csManager.reformat(newStatement));
        this.insertOldElements(elements, container, newStatement, chosenElement);
        newStatement = (OCStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(newStatement);
        if (newStatement == null) {
            return null;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project2);
        Document document2 = manager.getDocument(newStatement.getContainingFile());
        if (document2 != null) {
            manager.commitDocument(document2);
            csManager.adjustLineIndent((PsiFile)newStatement.getContainingOCFile(), newStatement.getRangeWithMacros());
        }
        return this.getSelectionRange(newStatement);
    }

    protected void insertOldElements(PsiElement[] elements, PsiElement container, T newStatement, @Nullable Object chosenElement) {
        PsiElement insertBeforeNode = this.getInsertionPlace(newStatement);
        PsiElement firstElement = elements[0];
        PsiElement lastElement = elements[elements.length - 1];
        insertBeforeNode.addRangeBefore(firstElement, lastElement, insertBeforeNode.getLastChild());
        if (OCElementUtil.getElementType(lastElement) == OCTokenTypes.EOL_COMMENT) {
            insertBeforeNode.addBefore(OCElementFactory.newlineFromText(lastElement), insertBeforeNode.getLastChild());
        }
        container.deleteChildRange(firstElement, lastElement);
    }

    private T upcast(OCStatement t) {
        return (T)t;
    }

    @NonNls
    protected abstract String getStatementTemplate(Project var1, PsiElement var2);

    protected abstract PsiElement getInsertionPlace(T var1);

    protected abstract TextRange getSelectionRange(T var1);
}

