/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.formatting.OCPostFormatVisitor;
import org.jetbrains.annotations.NotNull;

public class OCPostFormatProcessor
implements PostFormatProcessor {
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source.getLanguage() != OCLanguage.getInstance()) {
            return source;
        }
        if (ExternalFormatProcessor.useExternalFormatter((PsiFile)source.getContainingFile())) {
            return source;
        }
        return new OCPostFormatVisitor(settings).process(source);
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source.getLanguage() != OCLanguage.getInstance()) {
            return rangeToReformat;
        }
        if (ExternalFormatProcessor.useExternalFormatter((PsiFile)source)) {
            TextRange range = ExternalFormatProcessor.formatRangeInFile((PsiFile)source, (TextRange)rangeToReformat, (boolean)false);
            return range != null ? range : rangeToReformat;
        }
        return new OCPostFormatVisitor(settings).process(source, rangeToReformat);
    }
}

