/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiFile file;
        PsiElement psiElement = element.getPsi();
        if (psiElement == null) {
            return range;
        }
        if (psiElement.getLanguage() != OCLanguage.getInstance()) {
            return range;
        }
        PsiFile psiFile = file = psiElement.isValid() ? psiElement.getContainingFile() : null;
        if (file == null) {
            return range;
        }
        return TextRange.create((int)OCPreFormatProcessor.expandRange(file, range.getStartOffset(), true), (int)OCPreFormatProcessor.expandRange(file, range.getEndOffset(), false));
    }

    private static int expandRange(PsiFile file, int offset, boolean start) {
        PsiElement curr = file.findElementAt(start ? offset : offset - 1);
        if (curr == null) {
            return offset;
        }
        if (OCElementUtil.getElementType(curr) == OCTokenTypes.BLOCK_COMMENT) {
            offset = start ? curr.getTextOffset() : curr.getTextRange().getEndOffset();
        } else {
            if (!(curr instanceof OCMessageArgument)) {
                PsiElement psiElement = curr = start ? PsiTreeUtil.getPrevSiblingOfType((PsiElement)curr, OCMessageArgument.class) : PsiTreeUtil.getNextSiblingOfType((PsiElement)curr, OCMessageArgument.class);
            }
            while (curr != null) {
                PsiElement prevNext;
                PsiElement psiElement = prevNext = start ? curr.getPrevSibling() : curr.getNextSibling();
                if (prevNext != null) {
                    offset = prevNext.getTextOffset();
                }
                curr = prevNext;
            }
        }
        return offset;
    }
}

