/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModelWithShiftIndentInsideDocumentRange;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPsiBasedFormattingModel
extends PsiBasedFormattingModel
implements FormattingModelWithShiftIndentInsideDocumentRange {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final OCMultilineNodeFormatter myMultilineNodeFormatter;

    public OCPsiBasedFormattingModel(@NotNull PsiFile file, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        super(file, (Block)new OCCodeBlock(file, settings, mode), FormattingDocumentModelImpl.createOn((PsiFile)file));
        this.myFile = file;
        this.myMultilineNodeFormatter = new OCMultilineNodeFormatter(settings);
    }

    public TextRange shiftIndentInsideDocumentRange(Document document2, ASTNode node, TextRange textRange, int shift) {
        return this.myMultilineNodeFormatter.shiftIndentInsideRangeInDocument(document2, node, textRange, shift);
    }

    public String adjustWhiteSpaceInsideDocument(@Nullable ASTNode node, String whiteSpace) {
        if (OCElementUtil.getElementType(node) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT && OCMultilineNodeFormatter.PREPROCESSOR_INFO.get((UserDataHolder)node) != null) {
            Pair<String, String> splitIndent = OCMultilineNodeFormatter.splitIndent(whiteSpace);
            int codeIndent = this.myMultilineNodeFormatter.indent((String)splitIndent.second);
            if (codeIndent >= 120) {
                OCMultilineNodeFormatter.CODE_INDENT.set((UserDataHolder)node, (Object)(codeIndent -= 120));
                CharSequence chars = node.getChars();
                whiteSpace = chars.length() != 0 && chars.charAt(0) == '#' ? (String)splitIndent.first : (String)splitIndent.first + this.myMultilineNodeFormatter.getStringIndent(codeIndent);
            }
        }
        return whiteSpace;
    }

    public TextRange replaceWhiteSpace(TextRange textRange, ASTNode nodeAfter, String whiteSpace) {
        return super.replaceWhiteSpace(textRange, nodeAfter, this.adjustWhiteSpaceInsideDocument(nodeAfter, whiteSpace));
    }

    public TextRange shiftIndentInsideRange(ASTNode node, TextRange textRange, int shift) {
        TextRange newRange = this.myMultilineNodeFormatter.shiftIndentInsideRangeInPsiTree(node, textRange, shift);
        return newRange != null ? newRange : super.shiftIndentInsideRange(node, textRange, shift);
    }

    @Nullable
    protected ASTNode findElementAt(int offset) {
        if (DoxygenFacade.isDoxygenSupported()) {
            assert (!PsiDocumentManager.getInstance((Project)this.myFile.getProject()).isUncommited(this.getDocumentModel().getDocument()));
            PsiElement element = this.myFile.findElementAt(offset);
            if (element instanceof PsiComment) {
                return element.getNode();
            }
        }
        return super.findElementAt(offset);
    }
}

