/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCIndentChanger;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimpleBlock
implements Block,
OCIndentChanger {
    @NotNull
    protected OCCodeBlock myOwnerBlock;
    @NotNull
    private final List<Block> myBlocks;
    @NotNull
    private Indent myIndent;
    private TextRange myTextRange;
    @Nullable
    private final Wrap myWrap;
    @Nullable
    private final Alignment myAlignment;
    @NotNull
    private final ASTNode myFirst;
    @NotNull
    private final ASTNode myLast;

    public OCSimpleBlock(@Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, @NotNull OCCodeBlock ownerBlock, @NotNull List<Block> blocks) {
        assert (!blocks.isEmpty());
        this.myOwnerBlock = ownerBlock;
        this.myBlocks = blocks;
        this.myIndent = indent != null ? indent : Indent.getNoneIndent();
        this.myWrap = wrap;
        this.myAlignment = alignment;
        this.myFirst = OCSimpleBlock.extractFirstNode(this.myBlocks.get(0));
        this.myLast = OCSimpleBlock.extractLastNode(this.myBlocks.get(this.myBlocks.size() - 1));
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myTextRange == null) {
            this.myTextRange = OCSimpleBlock.getRangeFromSubBlocks(this);
        }
        return this.myTextRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        return this.myBlocks;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @NotNull
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        return this.myOwnerBlock.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block child = this.getSubBlocks().get(newChildIndex - 1);
        if (child instanceof ASTBlock && OCElementUtil.getElementType(((ASTBlock)child).getNode()) == OCTokenTypes.LBRACE) {
            return this.myOwnerBlock.getChildAttributes(1);
        }
        return new ChildAttributes(child.getIndent(), child.getAlignment());
    }

    public boolean isIncomplete() {
        return this.myOwnerBlock.isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return OCSimpleBlock.getTextFromRange(this.myOwnerBlock.getNode(), this.getTextRange());
    }

    public ASTNode getFirstNode() {
        return this.myFirst;
    }

    public ASTNode getLastNode() {
        return this.myLast;
    }

    @Contract(value="null->null")
    public static ASTNode extractFirstNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        if (block instanceof OCSimpleBlock) {
            return ((OCSimpleBlock)block).getFirstNode();
        }
        return null;
    }

    @Contract(value="null->null")
    public static ASTNode extractLastNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        if (block instanceof OCSimpleBlock) {
            return ((OCSimpleBlock)block).getLastNode();
        }
        return null;
    }

    @NotNull
    public static TextRange getRangeFromSubBlocks(@NotNull Block block) {
        List blocks = block.getSubBlocks();
        return blocks.size() == 0 ? TextRange.EMPTY_RANGE : new TextRange(((Block)blocks.get(0)).getTextRange().getStartOffset(), ((Block)blocks.get(blocks.size() - 1)).getTextRange().getEndOffset());
    }

    @NotNull
    public static String getTextFromRange(@NotNull ASTNode ownerNode, @NotNull TextRange range) {
        for (ASTNode up = ownerNode; up != null; up = up.getTreeParent()) {
            if (up.getStartOffset() > range.getStartOffset()) continue;
            ownerNode = up;
        }
        return range.shiftRight(-ownerNode.getStartOffset()).substring(ownerNode.getText()) + range;
    }

    @Override
    public void putIndent(Indent indent) {
        this.myIndent = indent;
    }
}

