/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.generate.FunctionQualifiedNameInfo;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCNewCppFunctionsLocator;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCNewImportLocation;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppDefinitionsUtil {
    private static final Comparator<OCGenerateUtil.Replacement> REPLACEMENT_COMPARATOR = (o1, o2) -> {
        if (!o1.position.file.equals(o2.position.file)) {
            return System.identityHashCode(o2.position.file) - System.identityHashCode(o1.position.file);
        }
        return o2.position.range.getStartOffset() - o1.position.range.getStartOffset();
    };

    @NotNull
    public static String functionSignature(@NotNull OCFunctionSymbol function, boolean isOutOfClassDefinition, @NotNull PsiElement context) {
        OCFunctionDeclaration funDefinition;
        StringBuilder answer = new StringBuilder();
        FunctionQualifiedNameInfo qualInfo = isOutOfClassDefinition ? OCCppGeneratedQualifiedFunctionKt.getQualifiedNameAndTemplateHeader(function, context) : new FunctionQualifiedNameInfo(function.getName(), "");
        answer.append(qualInfo.getTemplateHeader());
        if (function.isConstexpr()) {
            answer.append("constexpr ");
        }
        if (!isOutOfClassDefinition) {
            if (function.isVirtual()) {
                answer.append("virtual ");
            }
            if (function.isFriend()) {
                answer.append("friend ");
            }
            if (function.isStatic()) {
                answer.append("static ");
            }
            if (function.isExplicit()) {
                answer.append("explicit ");
            }
        }
        Project project2 = context.getProject();
        if (!(function.isCppConstructor() || function.isCppDestructor() || function.isCppConversionOperator())) {
            OCResolveContext resolveContext = OCResolveContext.forPsi(context);
            answer.append(function.getEffectiveResolvedType(resolveContext).getBestNameInContext(resolveContext, OCElementUtil.getReturnTypeTextWithModifiers(function, project2)));
            answer.append(' ');
        }
        answer.append(qualInfo.getQualifiedName());
        answer.append('(');
        boolean isFirstParam = true;
        for (OCDeclaratorSymbol param : function.getParameterSymbols()) {
            if (!isFirstParam) {
                answer.append(", ");
            }
            isFirstParam = false;
            answer.append(OCElementFactory.declarationText(param.getName(), param.getType(), OCElementUtil.getTypeTextWithModifiers(param, context.getProject()), null, context));
        }
        answer.append(')');
        function.getType().getCVQualifiers().appendCVQualifiers(answer);
        if (function.getType().isLValueRef()) {
            answer.append(" &");
        } else if (function.getType().isRValueRef()) {
            answer.append(" &&");
        }
        if (!isOutOfClassDefinition && function.isOverride()) {
            answer.append(" override");
        }
        if (!isOutOfClassDefinition && function.isFinal()) {
            answer.append(" final");
        }
        if (!isOutOfClassDefinition && function.isPureVirtual()) {
            answer.append(" = 0");
        }
        if (!isOutOfClassDefinition && function.isDefault()) {
            answer.append(" = default");
        }
        if (!isOutOfClassDefinition && function.isDelete()) {
            answer.append(" = delete");
        }
        if ((funDefinition = function.locateFunctionDefinition(project2)) != null) {
            OCTypeElement trailingType;
            OCNoexceptSpecifier noexceptSpecifier = funDefinition.getNoexceptSpecifier();
            if (noexceptSpecifier != null) {
                answer.append(" ");
                answer.append(noexceptSpecifier.getTextWithMacros());
            }
            if ((trailingType = funDefinition.getTrailingReturnTypeElement()) != null) {
                answer.append(" -> ").append(trailingType.getType().resolve(context).getBestNameInContext(context, trailingType.getTextWithMacros()));
            }
        }
        return answer.toString();
    }

    @NotNull
    public static SHOULD_GENERATE_DEFINITION shouldGenerateDefinitionsFor(@NotNull OCFunctionSymbol function, boolean checkNoncopyable, @NotNull Project project2) {
        OCType type;
        List<OCType> parameterTypes;
        PsiFile file = function.getContainingPsiFile(project2);
        if (!OCCodeInsightUtil.isValid((PsiElement)file)) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (function.isPureVirtual()) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!function.processSameSymbols((Processor<OCSymbol>)((Processor)s -> s.isPredeclaration() && (!(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isDefault() && !((OCFunctionSymbol)s).isDelete())), project2)) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!(function.getParent() instanceof OCStructSymbol)) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        if (checkNoncopyable && function.getVisibility() == OCVisibility.PRIVATE && (function.isCppConstructor() || function.isCppOperator() && function.getName().equals("operator=")) && (parameterTypes = function.getType().getParameterTypes()).size() == 1 && (type = parameterTypes.get(0)) instanceof OCCppReferenceType && function.getParent().getType().cloneWithConstModifier(project2).equalsAfterResolving(((OCCppReferenceType)type).getRefType(), OCResolveContext.forSymbol(function, project2))) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        return SHOULD_GENERATE_DEFINITION.REQUIRED;
    }

    @NotNull
    public static OCMembersContainer getFunctionParent(@NotNull OCFunctionSymbol function, @NotNull Project project2) {
        return function.getParent() instanceof OCNamespaceLikeSymbol ? (OCNamespaceLikeSymbol)((Object)function.getParent()) : function.getContainingOCFile(project2).getMembersContainer(false);
    }

    public static boolean shouldInlineNewDefinitions(@NotNull OCMembersContainer parent, @NotNull OCCaretLocation location) {
        Project project2 = location.getProject();
        if (location.getElement() != null) {
            if (!(parent instanceof OCSymbol) && parent.getContainingOCFile(project2).equals(location.getFile()) && OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2)) {
                return false;
            }
            if (OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project2))) {
                return false;
            }
        }
        return OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions((OCMembersContainer)parent, (Project)project2).shouldInline;
    }

    @Nullable
    public static OCGenerateUtil.ReplacePosition getOutsidePreferredPosition(@NotNull PsiFile file, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions) {
        OCFile sourceFile;
        if (functions.isEmpty() || !(file instanceof OCFile)) {
            return null;
        }
        Project project2 = file.getProject();
        BasedOnExistingResult basedOnExisting = OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions(parent, project2);
        if (basedOnExisting.outsideLocation != null) {
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby((Integer)basedOnExisting.outsideLocation.second, (PsiFile)basedOnExisting.outsideLocation.first);
        }
        if (OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2) && functions.stream().noneMatch(OCFunctionSymbol::isTemplateSymbol) && (sourceFile = ((OCFile)file).getAssociatedFile()) != null && !sourceFile.isHeader()) {
            PsiElement insertionParent = OCCppDefinitionsUtil.findInsertionParentInFile(sourceFile, (OCNamespaceSymbol)ObjectUtils.tryCast((Object)parent, OCNamespaceSymbol.class));
            ASTNode child = insertionParent.getNode().findChildByType((IElementType)OCTokenTypes.RBRACE);
            PsiElement rBrace = child != null ? child.getPsi() : null;
            int desiredOffset = rBrace != null ? rBrace.getTextRange().getStartOffset() : insertionParent.getTextRange().getEndOffset();
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(desiredOffset, sourceFile);
        }
        PsiElement fallbackLocation = OCCppDefinitionsUtil.defaultFallbackLocation(file, OCCppDefinitionsUtil.getParentDefinition(parent, project2), functions);
        return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(fallbackLocation.getTextRange().getEndOffset(), fallbackLocation.getContainingFile());
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getGenerateDefinitionReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @NotNull List<? extends OCCallable> predefinitions, @NotNull InlinePolicy inlinePolicy, boolean addImportReplacements) {
        if (inlinePolicy.shouldInline(location, parent)) {
            ArrayList<OCGenerateUtil.Replacement> replacements = new ArrayList<OCGenerateUtil.Replacement>(functions.size());
            assert (functions.size() == predefinitions.size());
            for (int i = 0; i < functions.size(); ++i) {
                PsiElement semicolon;
                OCFunctionSymbol symbol = functions.get(i);
                OCCallable predefinition = predefinitions.get(i);
                if (predefinition == null) continue;
                PsiElement lastChild = predefinition.getLastChild();
                PsiElement psiElement = semicolon = !OCElementUtil.isElementSignificant(lastChild) ? OCElementUtil.getPrevSignificantSibling(lastChild) : lastChild;
                if (semicolon == null || OCElementUtil.getElementType(semicolon) != OCTokenTypes.SEMICOLON) continue;
                replacements.add(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(predefinition.getContainingOCFile(), semicolon.getTextRange(), predefinition, false), OCCallableUtil.defaultFunctionBody(symbol, OCCallableUtil.getDefaultBaseToCall(symbol, predefinition.getProject()), predefinition)));
            }
            return replacements;
        }
        return OCCppDefinitionsUtil.getOutsideReplacements(location, parent, functions, null, addImportReplacements);
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getNewFunctionsReplacements(@NotNull OCCaretLocation location, @NotNull OCStructLike structDefinition, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> symbols, @Nullable List<String> bodies, @NotNull InlinePolicy inlinePolicy) {
        if (symbols.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder insideClassText = new StringBuilder();
        boolean shouldInline = inlinePolicy.shouldInline(location, parent);
        OCStructLike contextToCalculateNames = structDefinition;
        int insertPositionInsideClass = OCCppDefinitionsUtil.getInsertPositionForFunctionsInsideClass(structDefinition, location, symbols.get(0));
        OCVisibility initialVisibility = OCVisibility.getVisibilityAtOffset(structDefinition, insertPositionInsideClass);
        assert (initialVisibility != null);
        OCVisibility curVisibility = initialVisibility;
        for (int i = 0; i < symbols.size(); ++i) {
            OCFunctionSymbol functionSymbol = symbols.get(i);
            OCVisibility visibility = functionSymbol.getVisibility();
            if (visibility != curVisibility) {
                insideClassText.append((Object)visibility).append(": ");
                curVisibility = visibility;
            }
            String afterSignature = shouldInline ? (bodies == null ? OCCallableUtil.defaultFunctionBody(functionSymbol, OCCallableUtil.getDefaultBaseToCall(functionSymbol, location.getProject()), contextToCalculateNames) : bodies.get(i)) : ";";
            insideClassText.append(OCCppDefinitionsUtil.functionSignature(functionSymbol, false, structDefinition)).append(afterSignature);
        }
        if (OCCppDefinitionsUtil.shouldRestoreVisibility(structDefinition, insertPositionInsideClass, initialVisibility, curVisibility)) {
            insideClassText.append((Object)initialVisibility).append(": ");
        }
        PsiFile structDefinitionFile = structDefinition.getContainingFile();
        Document structDefinitionDocument = PsiDocumentManager.getInstance((Project)location.getProject()).getDocument(structDefinitionFile);
        if (structDefinitionDocument == null) {
            OCLog.LOG.warn("No document for " + structDefinitionFile);
            return Collections.emptyList();
        }
        List<OCGenerateUtil.Replacement> insideClassReplacements = Collections.singletonList(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(structDefinitionFile, TextRange.from((int)insertPositionInsideClass, (int)0), contextToCalculateNames), insideClassText.toString()));
        List outsideClassReplacements = shouldInline ? Collections.emptyList() : OCCppDefinitionsUtil.getOutsideReplacements(location, parent, symbols, bodies, false);
        return ContainerUtil.concat(insideClassReplacements, outsideClassReplacements);
    }

    @Nullable
    public static PsiElement getParentDefinition(@NotNull OCMembersContainer parent, @NotNull Project project2) {
        return parent instanceof OCSymbol ? ((OCSymbol)((Object)parent)).locateDefinition(project2) : parent.getContainingOCFile(project2);
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> getOutsideReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @Nullable List<String> bodies, boolean addImportReplacements) {
        OCGenerateUtil.ReplacePosition position;
        OCGenerateUtil.ReplacePosition replacePosition = position = OCCppDefinitionsUtil.shouldGenerateOutsideDefinitionAtCaret(location, parent) ? OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location) : OCCppDefinitionsUtil.getOutsidePreferredPosition(location.getFile(), parent, functions);
        if (position == null) {
            OCLog.LOG.warn("Can't find outside position for file '" + location.getFile() + "'");
            return Collections.emptyList();
        }
        THashSet filesToInclude = new THashSet();
        StringBuilder text = new StringBuilder();
        OCFile targetFile = (OCFile)position.file;
        for (int i = 0; i < functions.size(); ++i) {
            OCFunctionSymbol function = functions.get(i);
            text.append(OCCppDefinitionsUtil.functionSignature(function, true, position.context)).append(bodies != null ? bodies.get(i) : OCCallableUtil.defaultFunctionBody(function, OCCallableUtil.getDefaultBaseToCall(function, location.getProject()), position.context));
            VirtualFile fileToInclude = OCCppDefinitionsUtil.getFileToIncludeIfNeeded(function, targetFile);
            if (fileToInclude == null) continue;
            filesToInclude.add(fileToInclude);
        }
        OCGenerateUtil.Replacement incl = addImportReplacements ? OCCppDefinitionsUtil.calcIncludeReplacement(position, targetFile, (Set<VirtualFile>)filesToInclude) : null;
        OCGenerateUtil.Replacement definitions = new OCGenerateUtil.Replacement(position, text.toString());
        return incl == null ? Collections.singletonList(definitions) : OCCppDefinitionsUtil.mergeReplacements(Arrays.asList(incl, definitions));
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> mergeReplacements(@NotNull List<OCGenerateUtil.Replacement> replacements) {
        replacements = ContainerUtil.sorted(replacements, REPLACEMENT_COMPARATOR);
        ArrayList<OCGenerateUtil.Replacement> res = new ArrayList<OCGenerateUtil.Replacement>(replacements.size());
        for (OCGenerateUtil.Replacement r : replacements) {
            int lastIdx = res.size() - 1;
            if (res.isEmpty() || !OCCppDefinitionsUtil.intersects(res.get(lastIdx), r)) {
                res.add(r);
                continue;
            }
            res.set(lastIdx, OCCppDefinitionsUtil.union(res.get(lastIdx), r));
        }
        return res;
    }

    private static boolean intersects(@NotNull OCGenerateUtil.Replacement a, @NotNull OCGenerateUtil.Replacement b) {
        if (!a.position.file.equals(b.position.file)) {
            return false;
        }
        return a.position.range.intersects(b.position.range);
    }

    @NotNull
    private static OCGenerateUtil.Replacement union(@NotNull OCGenerateUtil.Replacement a, @NotNull OCGenerateUtil.Replacement b) {
        assert (a.position.file.equals(b.position.file));
        return new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(a.position.file, a.position.range.union(b.position.range), a.position.context, a.position.addNewLineBefore, b.position.addNewLineAfter), a.text + b.text);
    }

    @Nullable
    private static OCGenerateUtil.Replacement calcIncludeReplacement(OCGenerateUtil.ReplacePosition position, OCFile targetFile, Set<VirtualFile> filesToInclude) {
        List specs = filesToInclude.stream().map(vf -> OCImportSymbolFix.getFileNameToImport(vf, position.file)).filter(Objects::nonNull).sorted(Comparator.comparing(OCAutoImportHelper.ImportSpecification::getImportText)).collect(Collectors.toList());
        if (!specs.isEmpty()) {
            OCAutoImportHelper.ImportSpecification first = (OCAutoImportHelper.ImportSpecification)ContainerUtil.getFirstItem(specs);
            assert (first != null);
            OCNewImportLocation importLoc = OCImportSymbolFix.calcNewImportLocation(targetFile, position.range.getStartOffset(), "#include " + first.getImportText(), OCImportSymbolFix.ImportStyle.INCLUDE, first.getPreferredDelimiters());
            if (importLoc.getInsertAnchor() != null) {
                int offset = importLoc.getInsertBefore() ? importLoc.getInsertAnchor().getTextRange().getStartOffset() : importLoc.getInsertAnchor().getTextRange().getEndOffset();
                String includeText = specs.stream().map(spec -> "#include " + spec.getImportText() + "\n").collect(Collectors.joining());
                return new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(targetFile, TextRange.from((int)offset, (int)0), position.context), includeText);
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile getFileToIncludeIfNeeded(@NotNull OCFunctionSymbol function, @NotNull OCFile file) {
        VirtualFile targetVF = file.getVirtualFile();
        VirtualFile symbolVF = function.getContainingFile();
        if (targetVF == null || symbolVF == null || targetVF.equals(symbolVF)) {
            return null;
        }
        for (VirtualFile included : OCImportGraph.findImmediateIncludingFiles(file.getProject(), symbolVF, false)) {
            if (!targetVF.equals(included)) continue;
            return null;
        }
        return symbolVF;
    }

    @NotNull
    private static BasedOnExistingResult getBestLocationBasedOnExistingDefinitions(@NotNull OCMembersContainer parent, final @NotNull Project project2) {
        final OCFile topLevelFile = parent instanceof OCSymbol ? null : parent.getContainingOCFile(project2);
        class OffsetProcessor
        implements Processor {
            public boolean hasInlineDefinition = false;
            public boolean hasOutsideDefinition = false;
            public int maxOffset = 0;
            public PsiFile file = null;

            OffsetProcessor() {
            }

            @Nullable
            Pair<PsiFile, Integer> location() {
                return this.file == null ? null : Pair.create((Object)this.file, (Object)this.maxOffset);
            }

            boolean shouldBeInlined(@NotNull OCMembersContainer parent) {
                return !this.hasOutsideDefinition && (this.hasInlineDefinition || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2));
            }

            public boolean process(Object o) {
                ProgressManager.checkCanceled();
                if (!(o instanceof OCSymbol)) {
                    return true;
                }
                OCSymbol symbol = (OCSymbol)o;
                if (symbol.isPredeclaration()) {
                    PsiFile definitionFile;
                    PsiElement definition;
                    if (topLevelFile != null && symbol.getContainingOCFile(project2) != topLevelFile) {
                        return true;
                    }
                    OCSymbol definitionSymbol = symbol.getDefinitionSymbol(project2);
                    if (definitionSymbol != null && (definition = definitionSymbol.locateDefinition(project2)) != null && (definitionFile = definition.getContainingFile()) != null) {
                        if (this.file == null && OCCodeInsightUtil.isValid((PsiElement)definitionFile)) {
                            this.file = definitionFile;
                            this.hasOutsideDefinition = true;
                        }
                        if (this.file != null && this.file.equals(definitionFile)) {
                            this.maxOffset = Math.max(this.maxOffset, definition.getTextRange().getEndOffset());
                        }
                    }
                } else if (symbol instanceof OCFunctionSymbol) {
                    this.hasInlineDefinition = true;
                }
                return true;
            }
        }
        OffsetProcessor processor2 = new OffsetProcessor();
        parent.processMembers(null, processor2);
        return new BasedOnExistingResult(processor2.shouldBeInlined(parent), processor2.location());
    }

    private static boolean canDefinitionsBePlacedToAssocFile(@NotNull OCMembersContainer parent, @NotNull Project project2) {
        OCFile file = parent.getContainingOCFile(project2);
        if (file == null || !file.isHeader()) {
            return false;
        }
        OCFile assoc = file.getAssociatedFile();
        if (assoc == null || assoc.isHeader()) {
            return false;
        }
        return !(parent instanceof OCTemplateSymbol) || !((OCTemplateSymbol)((Object)parent)).isTemplateSymbol();
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(@NotNull OCCaretLocation location) {
        return location.getOffsetInFile() == null ? null : OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location.getOffsetInFile(), location.getFile());
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(int originalOffset, @NotNull PsiFile file) {
        PsiElement atCaret;
        Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document2 == null) {
            OCLog.LOG.warn("No document for " + file);
            return null;
        }
        PsiElement prev = null;
        for (PsiElement curr = atCaret = (PsiElement)ObjectUtils.notNull((Object)file.findElementAt(originalOffset), (Object)file); curr != null; curr = curr.getParent()) {
            if (curr instanceof OCCppNamespace || curr instanceof PsiFile) {
                int preferredOffset = -1;
                PsiElement context = null;
                if (curr instanceof OCCppNamespace && prev != null) {
                    boolean insideNamespaceHeader = false;
                    for (PsiElement nsChild = curr.getFirstChild(); nsChild != curr.getLastChild(); nsChild = nsChild.getNextSibling()) {
                        if (nsChild.equals(prev)) {
                            insideNamespaceHeader = true;
                        }
                        if (OCElementUtil.getElementType(nsChild) != OCTokenTypes.LBRACE) continue;
                        if (!insideNamespaceHeader) break;
                        preferredOffset = nsChild.getTextRange().getEndOffset();
                        context = curr;
                        break;
                    }
                }
                if (context == null) {
                    boolean isInsideComment = prev instanceof PsiComment && originalOffset > prev.getTextRange().getStartOffset();
                    preferredOffset = (prev == atCaret || prev == null) && !isInsideComment ? originalOffset : prev.getTextRange().getEndOffset();
                    context = curr;
                }
                return new OCGenerateUtil.ReplacePosition(file, TextRange.from((int)preferredOffset, (int)0), context);
            }
            prev = curr;
        }
        return null;
    }

    @NotNull
    private static PsiElement defaultFallbackLocation(@NotNull PsiFile file, @Nullable PsiElement parentDefinition, @NotNull List<OCFunctionSymbol> functions) {
        int maxOffset = -1;
        OCFunctionDeclaration result = null;
        for (OCFunctionSymbol symbol : functions) {
            OCFunctionDeclaration definition = symbol.locateFunctionDefinition(file.getProject());
            if (definition == null) continue;
            int offset = definition.getTextRange().getEndOffset();
            if (!file.equals(definition.getContainingFile()) || offset <= maxOffset) continue;
            maxOffset = offset;
            result = definition;
        }
        if (result != null) {
            return result;
        }
        if (parentDefinition != null && file.equals(parentDefinition.getContainingFile())) {
            return parentDefinition;
        }
        return file;
    }

    private static int getInsertPositionForFunctionsInsideClass(@NotNull OCStructLike structDefinition, @NotNull OCCaretLocation location, @NotNull OCFunctionSymbol newFunction) {
        int defaultOffset = OCNewCppFunctionsLocator.locateNewFunction(structDefinition, newFunction);
        if (location.getOffsetInFile() == null || !location.getFile().equals(structDefinition.getContainingFile())) {
            return defaultOffset;
        }
        int offset = location.getOffsetInFile();
        if (!OCNewCppFunctionsLocator.getValidLocationRange(structDefinition).contains(offset)) {
            return defaultOffset;
        }
        if (OCCppDefinitionsUtil.isLocationOutsideParent(location, structDefinition)) {
            return defaultOffset;
        }
        PsiElement elementToInsertAfter = null;
        boolean betweenVisibilityAndColon = false;
        for (PsiElement child = structDefinition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (OCElementUtil.isVisibilityKeyword(child.getNode())) {
                betweenVisibilityAndColon = true;
            } else if (OCElementUtil.getElementType(child) == OCTokenTypes.COLON) {
                betweenVisibilityAndColon = false;
            }
            if (betweenVisibilityAndColon || child.getTextRange().getEndOffset() < offset) continue;
            elementToInsertAfter = child;
            break;
        }
        if (elementToInsertAfter instanceof PsiWhiteSpace && elementToInsertAfter.getTextRange().contains(offset)) {
            return offset;
        }
        if (elementToInsertAfter != null) {
            return elementToInsertAfter.getTextRange().getEndOffset();
        }
        return defaultOffset;
    }

    private static boolean shouldRestoreVisibility(@NotNull OCStructLike definition, int pos, @NotNull OCVisibility initial, @Nullable OCVisibility lastNew) {
        if (initial == lastNew) {
            return false;
        }
        for (PsiElement child = definition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getTextRange().getStartOffset() < pos) continue;
            if (child instanceof OCDeclaration) {
                return true;
            }
            if (OCVisibility.getVisibilityFromElement(child) == null) continue;
            return false;
        }
        return false;
    }

    private static boolean isLocationOutsideParent(@NotNull OCCaretLocation location, @Nullable PsiElement parentDefinition) {
        assert (location.getElement() != null);
        return !PsiTreeUtil.isAncestor((PsiElement)parentDefinition, (PsiElement)location.getElement(), (boolean)false);
    }

    private static boolean shouldGenerateOutsideDefinitionAtCaret(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
        if (location.getElement() == null) {
            return false;
        }
        Project project2 = location.getProject();
        if (!(parent instanceof OCSymbol)) {
            return !parent.getContainingOCFile(project2).equals(location.getFile()) || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2);
        }
        return OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project2));
    }

    @NotNull
    private static PsiElement findInsertionParentInFile(OCFile file, OCNamespaceSymbol parent) {
        PsiElement namespacePsi;
        ArrayList<OCNamespaceSymbol> parentsPath = new ArrayList<OCNamespaceSymbol>();
        while (parent != null) {
            if (!(parent instanceof OCStructSymbol)) {
                parentsPath.add(0, parent);
            }
            parent = (OCNamespaceSymbol)parent.getParent();
        }
        OCNamespaceLikeSymbol current = file.getMembersContainer(false);
        for (OCNamespaceSymbol symbol : parentsPath) {
            final VirtualFile virtualFile = file.getContainingFile().getVirtualFile();
            CommonProcessors.FindFirstProcessor<OCNamespaceSymbol> finder = new CommonProcessors.FindFirstProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    ProgressManager.checkCanceled();
                    return virtualFile != null && virtualFile.equals(symbol.getContainingFile());
                }
            };
            current.processMembers(symbol.getName(), new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)finder, OCNamespaceSymbol.class));
            if (!finder.isFound()) break;
            current = (OCNamespaceLikeSymbol)finder.getFoundValue();
        }
        if (current instanceof OCNamespaceSymbol && (namespacePsi = ((OCNamespaceSymbol)current).locateDefinition(file.getProject())) != null) {
            return namespacePsi;
        }
        return file;
    }

    private static class BasedOnExistingResult {
        public final boolean shouldInline;
        @Nullable
        public final Pair<PsiFile, Integer> outsideLocation;

        private BasedOnExistingResult(boolean inline, @Nullable Pair<PsiFile, Integer> location) {
            this.shouldInline = inline;
            this.outsideLocation = location;
            assert (this.outsideLocation == null || !this.shouldInline);
        }
    }

    public static enum InlinePolicy {
        INLINE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return true;
            }
        }
        ,
        OUTSIDE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return false;
            }
        }
        ,
        PREFERRED{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return OCCppDefinitionsUtil.shouldInlineNewDefinitions(parent, location);
            }
        };


        public abstract boolean shouldInline(@NotNull OCCaretLocation var1, @NotNull OCMembersContainer var2);

        public static InlinePolicy get(boolean inline) {
            return inline ? INLINE : OUTSIDE;
        }
    }

    public static enum SHOULD_GENERATE_DEFINITION {
        NO,
        POSSIBLE,
        REQUIRED;

    }
}

