/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateUtil {
    @NotNull
    public static PsiElement getElementAt(@Nullable Editor editor, @NotNull PsiFile file) {
        return (PsiElement)ObjectUtils.notNull((Object)OCGenerateUtil.findElementAt(editor, file), (Object)file);
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable Editor editor, @NotNull PsiFile file) {
        return editor != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    public static boolean shouldInsertNewLineBefore(@NotNull CharSequence sequence, int at) {
        int prevNonSpace = CharArrayUtil.shiftBackward((CharSequence)sequence, (int)(at - 1), (String)" \t");
        return prevNonSpace < 0 || prevNonSpace >= sequence.length() || !StringUtil.isLineBreak((char)sequence.charAt(prevNonSpace));
    }

    public static boolean shouldInsertNewLineAfter(@NotNull CharSequence sequence, int at) {
        int nextNonSpace = CharArrayUtil.shiftForward((CharSequence)sequence, (int)at, (String)" \t");
        return nextNonSpace >= sequence.length() || !StringUtil.isLineBreak((char)sequence.charAt(nextNonSpace));
    }

    public static List<PsiFile> getAffectedFiles(@NotNull List<Replacement> replacements) {
        return replacements.stream().map(r -> r.position.file).distinct().collect(Collectors.toList());
    }

    public static void applyReplacements(@NotNull Project project2, @NotNull List<Replacement> replacements, boolean fixImports) {
        HashSet documents = new HashSet();
        List repsAndMarkers = ContainerUtil.mapNotNull(replacements, replacement -> {
            Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(replacement.position.file);
            if (document2 == null) {
                OCLog.LOG.warn("Can't get document for " + replacement.position.file);
                return null;
            }
            documents.add(document2);
            RangeMarker marker = document2.createRangeMarker(replacement.position.range);
            marker.setGreedyToRight(true);
            return Pair.create((Object)replacement, (Object)marker);
        });
        for (Document document2 : documents) {
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document2);
        }
        for (Pair repAndMarker : repsAndMarkers) {
            Replacement r = (Replacement)repAndMarker.first;
            ReplacePosition p = r.position;
            RangeMarker marker = (RangeMarker)repAndMarker.second;
            marker.getDocument().replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)r.text);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(marker.getDocument());
            OCChangeUtil.reformatTextIfNotInjected(p.file, marker.getStartOffset(), CharArrayUtil.shiftForward((CharSequence)marker.getDocument().getCharsSequence(), (int)marker.getEndOffset(), (String)" \t\n"));
            if (!fixImports) continue;
            OCImportSymbolFix.fixAllSymbolsRecursively((PsiElement)p.file, TextRange.create((Segment)marker));
        }
        boolean selected = false;
        for (Pair repAndMarker : repsAndMarkers) {
            if (!selected) {
                selected = OCCodeInsightUtil.showCallableInEditorAndSelectBody(((Replacement)repAndMarker.first).position.file, (Segment)repAndMarker.second, (Condition<OCBlockStatement>)((Condition)body -> true));
            }
            ((RangeMarker)repAndMarker.second).dispose();
        }
    }

    public static class Replacement {
        @NotNull
        public final ReplacePosition position;
        @NotNull
        public final String text;

        public Replacement(@NotNull ReplacePosition position, @NotNull String text) {
            this.position = position;
            this.text = (position.addNewLineBefore ? "\n" : "") + text + (position.addNewLineAfter ? "\n" : "");
        }
    }

    public static class ReplacePosition {
        @NotNull
        public final PsiFile file;
        @NotNull
        public final TextRange range;
        @NotNull
        public final PsiElement context;
        public final boolean addNewLineBefore;
        public final boolean addNewLineAfter;

        public ReplacePosition(@NotNull PsiFile file, @NotNull TextRange range, @NotNull PsiElement context) {
            this(file, range, context, true);
        }

        public ReplacePosition(@NotNull PsiFile file, @NotNull TextRange range, @NotNull PsiElement context, boolean fixNewLineBefore) {
            this.file = file;
            this.range = range;
            this.context = context;
            Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            this.addNewLineBefore = fixNewLineBefore && (document2 == null || OCGenerateUtil.shouldInsertNewLineBefore(document2.getCharsSequence(), range.getStartOffset()));
            this.addNewLineAfter = document2 == null || OCGenerateUtil.shouldInsertNewLineAfter(document2.getCharsSequence(), range.getEndOffset());
        }

        public ReplacePosition(@NotNull PsiFile file, @NotNull TextRange range, @NotNull PsiElement context, boolean addNewLineBefore, boolean addNewLineAfter) {
            this.file = file;
            this.range = range;
            this.context = context;
            this.addNewLineBefore = addNewLineBefore;
            this.addNewLineAfter = addNewLineAfter;
        }
    }
}

