/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.generate.actions.OCFileNavigationItemForGenerationPopup;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileSymbolsContainerBase;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCActionContext<P extends OCMembersContainer, M extends OCSymbolWithParent> {
    @Nullable
    private final P myParent;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private Map<OCOption, Object> myOptionValues;

    public OCActionContext(@Nullable P parent, @NotNull PsiElement context) {
        this.myParent = parent;
        this.myContext = context;
    }

    @NotNull
    public final P getParent() {
        assert (this.myParent != null);
        return this.myParent;
    }

    @NotNull
    public final PsiElement getContext() {
        return this.myContext;
    }

    public boolean isValid() {
        return this.myParent != null && (!(this.myParent instanceof OCSymbol) || !((OCSymbol)this.myParent).isPredeclaration());
    }

    public List<? extends OCSymbol> getSymbolsToModify() {
        return this.myParent instanceof OCSymbol ? Collections.singletonList((OCSymbol)this.myParent) : Collections.emptyList();
    }

    @Nullable
    public Map<OCOption, Object> getOptionValues() {
        return this.myOptionValues;
    }

    public void setOptionValues(@Nullable Map<OCOption, Object> optionValues) {
        this.myOptionValues = optionValues;
    }

    @NotNull
    public abstract Collection<M> getMemberCandidates();

    public abstract Map<OCSymbol, OCSymbol> createParentsMap(Collection<M> var1);

    public String getParentNameUppercase() {
        return "'" + this.getParentPresentableName() + "'";
    }

    @NotNull
    public Project getProject() {
        return this.myContext.getProject();
    }

    @NotNull
    public OCResolveContext createResolveContext() {
        return OCResolveContext.forPsi(this.myContext);
    }

    @NotNull
    public String getParentPresentableName() {
        if (this.myParent instanceof OCFileSymbolsContainerBase) {
            return "File '" + ((OCFileSymbolsContainerBase)this.myParent).getContainingOCFile(this.getProject()).getName() + "'";
        }
        if (this.myParent instanceof OCSymbol) {
            return ((OCSymbol)this.myParent).getPresentableName();
        }
        throw new IllegalStateException("Parent should be either symbol or file symbol container!");
    }

    @NotNull
    public PsiElementNavigationItem getParentNavigationItem() {
        if (this.myParent instanceof OCFileSymbolsContainerBase) {
            return new OCFileNavigationItemForGenerationPopup(((OCFileSymbolsContainerBase)this.myParent).getContainingOCFile(this.getProject()));
        }
        if (this.myParent instanceof OCSymbol) {
            return new OCSymbolNavigationItem((OCSymbol)this.myParent, this.getProject());
        }
        throw new IllegalStateException("Parent should be either symbol or file symbol container!");
    }
}

