/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCGenerateGetterSetterContext
extends OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> {
    private Mode myMode;

    public OCGenerateGetterSetterContext(OCStructSymbol parent, PsiElement context, Mode mode) {
        super(parent, context);
        this.myMode = mode;
    }

    public boolean hasGetter(OCDeclaratorSymbol field) {
        Project project2 = this.getProject();
        return !((OCStructSymbol)this.getParent()).processFunctions(OCNameSuggester.getCppGetterName(field, project2), (Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol function) {
                return function.getParameterSymbols().isEmpty();
            }
        });
    }

    public boolean hasSetter(final OCDeclaratorSymbol field) {
        final Project project2 = this.getProject();
        return !((OCStructSymbol)this.getParent()).processFunctions(OCNameSuggester.getCppSetterName(field, project2), (Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol function) {
                if (function.getParameterSymbols().size() == 1) {
                    OCType type = function.getParameterSymbols().get(0).getType();
                    while (type instanceof OCCppReferenceType) {
                        type = ((OCCppReferenceType)type).getRefType();
                    }
                    if (new OCTypeEqualityAfterResolvingVisitor(field.getType(), false, false, true, true, OCResolveContext.forSymbol(function, project2)).equal(type)) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public boolean needGetter(OCDeclaratorSymbol field) {
        return (this.myMode == Mode.GETTER || this.myMode == Mode.GETTER_SETTER) && !this.hasGetter(field) && !OCGenerateGetterSetterContext.isMultiArray(field, OCResolveContext.forPsi(this.getContext()));
    }

    public boolean needSetter(OCDeclaratorSymbol field) {
        return (this.myMode == Mode.SETTER || this.myMode == Mode.GETTER_SETTER) && !this.hasSetter(field) && !OCGenerateGetterSetterContext.isReadOnly(field) && !OCGenerateGetterSetterContext.isArray(field, OCResolveContext.forPsi(this.getContext()));
    }

    private static boolean isMultiArray(OCDeclaratorSymbol field, @NotNull OCResolveContext context) {
        OCType fieldType = field.getType().resolve(context);
        if (!(fieldType instanceof OCArrayType)) {
            return false;
        }
        return ((OCArrayType)fieldType).getRefType().resolve(context) instanceof OCArrayType;
    }

    private static boolean isArray(OCDeclaratorSymbol field, @NotNull OCResolveContext context) {
        return field.getType().resolve(context) instanceof OCArrayType;
    }

    private static boolean isReadOnly(OCDeclaratorSymbol field) {
        return field.isConst() || field.getType() instanceof OCCppReferenceType && ((OCCppReferenceType)field.getType()).isReferenceToConst();
    }

    @Override
    @NotNull
    public Collection<OCDeclaratorSymbol> getMemberCandidates() {
        ArrayList<OCDeclaratorSymbol> list = new ArrayList<OCDeclaratorSymbol>();
        ((OCStructSymbol)this.getParent()).processFields((Processor<? super OCDeclaratorSymbol>)((Processor)field -> {
            if (field.getKind() == OCSymbolKind.STRUCT_FIELD && !OCCodeInsightUtil.isUnnamed(field) && (this.needGetter((OCDeclaratorSymbol)field) || this.needSetter((OCDeclaratorSymbol)field))) {
                list.add((OCDeclaratorSymbol)field);
            }
            return true;
        }));
        return list;
    }

    public static enum Mode {
        GETTER,
        SETTER,
        GETTER_SETTER;

    }
}

