/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDescriptionHandler
extends OCGenerateMethodHandler {
    private static final OCBooleanOption INCLUDE_MEMBER_NAMES = new OCBooleanOption("Include member names");

    @Override
    @NotNull
    protected String getActionTitle() {
        return "Generate -description";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"description"};
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    protected boolean defaultIncludeMemberNames(@Nullable OCCodeStyleSettings settings) {
        return settings == null || settings.DESCRIPTION_INCLUDE_MEMBER_NAMES;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateMethodActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        options.add((Pair<OCOption, Object>)new Pair((Object)INCLUDE_MEMBER_NAMES, (Object)this.defaultIncludeMemberNames(settings)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        settings.DESCRIPTION_INCLUDE_MEMBER_NAMES = OCGenerateDescriptionHandler.getOption(optionValues, INCLUDE_MEMBER_NAMES);
        super.saveOptions(file, settings, optionValues);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol oCImplementationSymbol;
        if (element instanceof OCInterface) {
            return OCCallableUtil.methodSignature(actionContext.getBaseMethod(), element, actionContext.createResolveContext()) + ";";
        }
        boolean includeMemberNames = this.getOption(actionContext, INCLUDE_MEMBER_NAMES);
        ArrayList<Pair<String, String>> strings = new ArrayList<Pair<String, String>>();
        StringBuilder body = new StringBuilder();
        boolean isFirst = true;
        OCResolveContext context = OCResolveContext.forPsi(element);
        for (OCInstanceVariableSymbol oCInstanceVariableSymbol : ivars) {
            OCPropertySymbol property = oCInstanceVariableSymbol.getAssociatedProperty(actionContext.getProject());
            OCType type = oCInstanceVariableSymbol.getType().resolve(element, true);
            OCGenerateDescriptionHandler.appendMember(strings, property != null ? "self." + property.getName() : oCInstanceVariableSymbol.getName(), type, includeMemberNames, context);
        }
        for (Pair pair2 : strings) {
            body.append("[description appendFormat: @\"");
            if (!isFirst) {
                body.append(", ");
            }
            body.append((String)pair2.getFirst()).append("\", ").append((String)pair2.getSecond()).append("];\n");
            isFirst = false;
        }
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol2 = oCImplementationSymbol = superType != null ? superType.getImplementation() : null;
        String templateName = oCImplementationSymbol != null && !oCImplementationSymbol.processMembersInAllCategories("description", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true, actionContext.getProject()) ? "OC Overridden Description Body 1.m" : (strings.size() > 0 ? "OC Overridden Description Body 2.m" : "OC Overridden Description Body 3.m");
        return OCCallableUtil.methodFromTemplate(actionContext.getBaseMethod(), templateName, body.toString().trim(), element);
    }

    private static void appendMember(List<Pair<String, String>> strings, String memberName, OCType type, boolean includeMemberNames, @NotNull OCResolveContext context) {
        if (type instanceof OCStructType && !type.isScalar()) {
            if (!OCGenerateDescriptionHandler.processStructFields(type, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
                OCGenerateDescriptionHandler.appendMember(strings, memberName + "." + field.getName(), field.getResolvedType(context), includeMemberNames, context);
                return true;
            }), context)) {
                strings.add((Pair<String, String>)Pair.create((Object)(includeMemberNames ? memberName + "=%s" : "%s"), (Object)("(const char*)" + memberName)));
            }
        } else {
            strings.add((Pair<String, String>)Pair.create((Object)(includeMemberNames ? memberName + "=" + type.getFormatString() : type.getFormatString()), (Object)memberName));
        }
    }
}

