/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateEncodeHandler
extends OCGenerateMethodHandler {
    @Override
    @NotNull
    protected String getActionTitle() {
        return "Generate -encodeWithCoder:/-initWithCoder:";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"initWithCoder:", "encodeWithCoder:"};
    }

    @Override
    @Nullable
    protected String getParentProtocol() {
        return "NSCoding";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateMethodActionContext context) {
        return context.getParentNameUppercase() + " has no encodable members";
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext actionContext) {
        OCMethodSymbol initMethod = actionContext.getBaseMethods().get(0);
        OCMethodSymbol encodeMethod = actionContext.getBaseMethods().get(1);
        StringBuilder builder = new StringBuilder();
        if (element instanceof OCInterface) {
            builder.append(OCCallableUtil.methodSignature(initMethod, element, actionContext.createResolveContext())).append(";");
            builder.append(OCCallableUtil.methodSignature(encodeMethod, element, actionContext.createResolveContext())).append(";");
        } else {
            OCMethodSymbol initBaseMethod;
            StringBuilder initBody = new StringBuilder();
            StringBuilder encodeBody = new StringBuilder();
            OCObjectType superType = actionContext.getType().getSuperType();
            OCProtocolSymbol codingProtocol = (OCProtocolSymbol)initMethod.getParent();
            OCType coderType = initMethod.getSelectors().get(0).getParameter().getType().resolve(element, true);
            if (superType != null && superType.implementsProtocol(codingProtocol)) {
                encodeBody.append("[super encodeWithCoder: coder];\n");
                initBaseMethod = initMethod;
            } else {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                if (superType != null) {
                    superType.processMembers("init", OCMethodSymbol.class, finder);
                }
                initBaseMethod = (initBaseMethod = (OCMethodSymbol)finder.getFoundValue()) != null ? initBaseMethod : initMethod;
            }
            for (OCInstanceVariableSymbol ivar : members) {
                OCPropertySymbol property = ivar.getAssociatedProperty(actionContext.getProject());
                OCType type = ivar.getType().resolve(element, true);
                boolean hasSetter = property != null && !property.isReadonly();
                String initMemberName = hasSetter ? "self." + property.getName() : ivar.getName();
                String encodeMemberName = property != null ? "self." + property.getName() : ivar.getName();
                OCGenerateEncodeHandler.appendMember(initBody, encodeBody, type, initMemberName, encodeMemberName, codingProtocol, coderType, hasSetter ? null : ivar, actionContext.getNonReleasedIvars(), element);
            }
            builder.append(OCCallableUtil.methodText(initBaseMethod, null, OCCallableUtil.methodSignature(initMethod, element, actionContext.createResolveContext()), initBody.toString().trim(), element));
            builder.append(OCCallableUtil.methodText(OCCallableUtil.methodSignature(encodeMethod, element, actionContext.createResolveContext()), encodeBody.toString().trim(), element));
        }
        return builder.toString();
    }

    @Override
    protected boolean showSymbolInChooser(OCInstanceVariableSymbol ivar, OCGenerateMethodActionContext actionContext) {
        if (!super.showSymbolInChooser(ivar, actionContext)) {
            return false;
        }
        OCType type = ivar.getType().resolve(actionContext.getContext(), true);
        OCProtocolSymbol codingProtocol = (OCProtocolSymbol)actionContext.getBaseMethods().get(0).getParent();
        return OCGenerateEncodeHandler.appendMember(new StringBuilder(), new StringBuilder(), type, "", "", codingProtocol, null, null, new ArrayList<OCInstanceVariableSymbol>(), actionContext.getContext());
    }

    @Override
    protected void performAction(@NotNull Project project2, @NotNull PsiElement element, int caretPos, PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext context) {
        super.performAction(project2, element, caretPos, at, members, context);
        if (element instanceof OCImplementation && !context.getNonReleasedIvars().isEmpty()) {
            new OCReleaseVariablesIntentionAction(context.getNonReleasedIvars(), context.getProject()).invoke(project2, null, element.getContainingFile());
        }
    }

    private static boolean appendMember(StringBuilder initBody, StringBuilder encodeBody, OCType type, String initMemberName, String encodeMemberName, OCProtocolSymbol codingProtocol, @Nullable OCType coderType, @Nullable OCInstanceVariableSymbol ivar, List<OCInstanceVariableSymbol> nonReleasedIvars, PsiElement context) {
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type instanceof OCStructType && !type.isScalar() && coderType != null && coderType.isPointerToObject()) {
            OCDeclaratorSymbol encodeParam;
            OCObjectType coderObjectType = (OCObjectType)coderType.getTerminalType();
            String typeName = type.getName();
            typeName = typeName.startsWith("NS") ? typeName.substring(2) : typeName;
            OCMethodSymbol encodeMethod = coderObjectType.findMember("encode" + typeName + ":forKey:", OCMethodSymbol.class);
            OCMethodSymbol decodeMethod = coderObjectType.findMember("decode" + typeName + "ForKey:", OCMethodSymbol.class);
            if (encodeMethod != null && decodeMethod != null && (encodeParam = encodeMethod.getSelectors().get(0).getParameter()) != null && type.equalsAfterResolving(encodeParam.getType(), resolveContext) && type.equalsAfterResolving(decodeMethod.getReturnType(resolveContext.getProject()), resolveContext)) {
                encodeBody.append("[coder encode").append(typeName).append(":").append(encodeMemberName);
                encodeBody.append(" forKey:@\"").append(initMemberName).append("\"];\n");
                initBody.append(initMemberName).append("=").append("[coder decode").append(typeName).append("ForKey:@\"");
                initBody.append(initMemberName).append("\"];\n");
                return true;
            }
        }
        if (OCGenerateEncodeHandler.processStructFields(type, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
            OCGenerateEncodeHandler.appendMember(initBody, encodeBody, field.getResolvedType(resolveContext), initMemberName + "." + field.getName(), encodeMemberName + "." + field.getName(), codingProtocol, coderType, null, nonReleasedIvars, context);
            return true;
        }), resolveContext)) {
            return true;
        }
        if (type.isPointerToObject() && ((OCObjectType)type.getTerminalType()).implementsProtocol(codingProtocol)) {
            encodeBody.append("[coder encodeObject:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=");
            if (ivar != null && OCCompilerFeatures.isArcDisabled(context.getContainingFile())) {
                initBody.append("[[coder decodeObjectForKey:@\"").append(initMemberName).append("\"]");
                initBody.append(type.isPointerToString() ? "copy" : "retain").append("];\n");
                nonReleasedIvars.add(ivar);
            } else {
                initBody.append("[coder decodeObjectForKey:@\"").append(initMemberName).append("\"];\n");
            }
            return true;
        }
        if (OCIntType.isBool(type, resolveContext)) {
            encodeBody.append("[coder encodeBool:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeBoolForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type instanceof OCIntType && ((OCIntType)type).getRank(resolveContext) > OCIntType.INT.getRank(resolveContext)) {
            encodeBody.append("[coder encodeInt64:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeInt64ForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type.isIntegerCompatible(resolveContext)) {
            encodeBody.append("[coder encodeInt:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            String cast = type.isCompatible(OCIntType.INT, resolveContext) ? "" : "(" + type.getBestNameInContext(resolveContext) + ")";
            initBody.append(initMemberName).append("=").append(cast).append("[coder decodeIntForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type.equals(OCRealType.FLOAT, resolveContext)) {
            encodeBody.append("[coder encodeFloat:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeFloatForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type instanceof OCRealType) {
            encodeBody.append("[coder encodeDouble:").append(encodeMemberName).append(" forKey:@\"").append(initMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=").append("[coder decodeDoubleForKey:@\"").append(initMemberName).append("\"];\n");
            return true;
        }
        if (type.isPointerToChar()) {
            encodeBody.append("[coder encodeObject: [NSData dataWithBytes: ").append(initMemberName).append(" length: strlen(");
            encodeBody.append(initMemberName).append(")] forKey:@\"").append(encodeMemberName).append("\"];\n");
            initBody.append(initMemberName).append("=strdup(").append("((NSData*)[coder decodeObjectForKey:@\"").append(initMemberName).append("\"]).bytes);\n");
            return true;
        }
        return false;
    }
}

