/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCOverrideImplementMethodsHandlerBase;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementOCMethodsHandler
extends OCOverrideImplementMethodsHandlerBase {
    private static final OCBooleanOption SHOW_OPTIONAL = new OCBooleanOption(UIUtil.removeMnemonic((String)OCBundle.message("override.implement.show.optional.members", new Object[0])));
    private static final OCBooleanOption SHOW_SYNTHESIZED_ACCESSORS = new OCBooleanOption(OCBundle.message("override.implement.show.synthesized.accessors", new Object[0]));

    @Override
    protected String getNoMembersMessage(@NotNull OCOverrideImplementActionContext context) {
        return context.getParentNameUppercase() + " has no methods to implement";
    }

    protected boolean defaultShowOptional() {
        return false;
    }

    protected boolean defaultShowSynthesizedAccessors() {
        return false;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCOverrideImplementActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_OPTIONAL, (Object)this.defaultShowOptional()));
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED_ACCESSORS, (Object)this.defaultShowSynthesizedAccessors()));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, final @NotNull PsiElement element) {
        return new OCOverrideImplementActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element){

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                final HashSet names = new HashSet();
                CommonProcessors.CollectProcessor<OCMethodSymbol> processor2 = new CommonProcessors.CollectProcessor<OCMethodSymbol>(){

                    protected boolean accept(OCMethodSymbol symbol) {
                        if (names.add(symbol.getName())) {
                            myAbstractMethods.add(symbol);
                            return true;
                        }
                        return false;
                    }
                };
                if (this.getType().getClassSymbol() == null) {
                    return Collections.emptyList();
                }
                this.getType().processInterfaceMethods(this.getInterfaceSymbol(), null, (Processor<OCMethodSymbol>)processor2, element, true);
                return processor2.getResults();
            }
        };
    }

    @Override
    @NotNull
    protected Collection<OCMethodSymbol> getSelectedCandidates(@NotNull OCOverrideImplementActionContext actionContext, Editor editor, @NotNull PsiFile file, @NotNull List<OCMethodSymbol> candidates) {
        if (this.selectAllCandidates()) {
            ArrayList<OCMethodSymbol> result = new ArrayList<OCMethodSymbol>();
            for (OCMethodSymbol method : actionContext.getMemberCandidates()) {
                if (method.isOptional()) continue;
                result.add(method);
            }
            return result;
        }
        return super.getSelectedCandidates(actionContext, editor, file, candidates);
    }

    protected boolean selectAllCandidates() {
        return true;
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Methods to Implement";
    }

    @Override
    protected String generateMethodText(OCMethodSymbol baseMethod, PsiElement context, OCOverrideImplementActionContext actionContext) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        OCPropertySymbol property = baseMethod.getGeneratedFromProperty();
        if (property != null) {
            map2.put("IVAR_IS_AVAILABLE", actionContext.isIvarAvailable(property) ? "true" : "false");
        }
        return OCCallableUtil.methodFromTemplate(baseMethod, "OC Implemented Method Body.m", context, map2, actionContext.getProject());
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCMethodSymbol> candidates, OCOverrideImplementActionContext actionContext, int moreNodesLevel) {
        ArrayList<OCMethodSymbol> filteredCandidates = new ArrayList<OCMethodSymbol>();
        if (moreNodesLevel > 0) {
            chooser.setOptionSelection(SHOW_OPTIONAL, true);
        }
        if (moreNodesLevel > 1) {
            chooser.setOptionSelection(SHOW_SYNTHESIZED_ACCESSORS, true);
        }
        Boolean showOptionalMethods = OCClassActionHandlerBase.getOption(chooser.getOptionSelections(), SHOW_OPTIONAL);
        Boolean showSynthesizedAccessors = OCClassActionHandlerBase.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED_ACCESSORS);
        if (candidates.isEmpty()) {
            return super.getChooserNodes(chooser, filteredCandidates, actionContext, moreNodesLevel);
        }
        Project project2 = actionContext.getProject();
        OCImplementationSymbol parent = candidates.iterator().next().getParent().getImplementation(project2);
        HashSet synthesizedProperties = new HashSet();
        if (parent != null) {
            parent.processMembers(OCSynthesizeSymbol.class, symbol -> {
                synthesizedProperties.add(symbol.getName());
                return true;
            });
        }
        int optionalSize = 0;
        int synthesizedSize = 0;
        for (OCMethodSymbol candidate : candidates) {
            OCPropertySymbol property = candidate.getGeneratedFromProperty();
            if (candidate.isOptional()) {
                ++optionalSize;
                if (!showOptionalMethods.booleanValue()) continue;
            }
            if (property != null && (synthesizedProperties.contains(property.getName()) || OCCompilerFeatures.supportsAutosynthesis(property.getContainingOCFile(project2))) && !(property.getParent() instanceof OCProtocolSymbol)) {
                ++synthesizedSize;
                if (!showSynthesizedAccessors.booleanValue()) continue;
            }
            filteredCandidates.add(candidate);
        }
        OCBooleanOption.setStates(chooser.getOptionComponent(SHOW_OPTIONAL), optionalSize == 0, "override.implement.show.no.optional.members", optionalSize == candidates.size(), "override.implement.show.only.optional.members");
        OCBooleanOption.setStates(chooser.getOptionComponent(SHOW_SYNTHESIZED_ACCESSORS), synthesizedSize == 0, "override.implement.show.no.synthesized.accessors", synthesizedSize == candidates.size(), "override.implement.show.only.synthesized.accessors");
        Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        OCMemberChooserObject[] nodes = (OCMemberChooserObject[])ContainerUtil.map2Array(filteredCandidates, OCMemberChooserObject.class, m -> {
            Icon icon = m.getIcon(project2);
            if (!icon.equals(OCSymbolKind.PROPERTY.getIcon())) {
                icon = OCIcons.getMethodIcon(m.isStatic(), m.isOptional(), actionContext.isAbstract((OCMethodSymbol)m));
            }
            return new OCMemberChooserObject((OCSymbol)m, icon, parentsMap, project2);
        });
        return nodes;
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCMethodSymbol> candidates, OCOption option, OCOverrideImplementActionContext actionContext) {
        if (SHOW_OPTIONAL.equals(option) || SHOW_SYNTHESIZED_ACCESSORS.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCOverrideImplementActionContext actionContext, @NotNull List<OCMethodSymbol> chosenCandidates) {
        if (actionContext.evaluateAvailableIvars(file, chosenCandidates, this.getActionTitle())) {
            super.performAction(project2, editor, file, actionContext, chosenCandidates);
        }
    }
}

