/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class OCCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int myUsageCount = 1;
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private final boolean myNavigateToReference;
    private final Set<OCSymbol> myPossibleResponders;

    public OCCallHierarchyNodeDescriptor(Project project2, HierarchyNodeDescriptor parentDescriptor, PsiElement element, boolean isBase, boolean navigateToReference) {
        super(project2, (NodeDescriptor)parentDescriptor, element, isBase);
        this.myNavigateToReference = navigateToReference;
        this.myPossibleResponders = new HashSet<OCSymbol>();
    }

    @Nullable
    public final OCCallable getEnclosingElement() {
        PsiElement element = this.getPsiElement();
        return element == null ? null : OCCallHierarchyNodeDescriptor.getEnclosingElement(element);
    }

    public Set<OCSymbol> getPossibleResponders() {
        return this.myPossibleResponders;
    }

    public void addPossibleResponder(OCSymbol symbol) {
        this.myPossibleResponders.add(symbol);
    }

    @Nullable
    static OCCallable getEnclosingElement(PsiElement element) {
        return (OCCallable)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class});
    }

    public final void incrementUsageCount() {
        ++this.myUsageCount;
    }

    public final PsiElement getTargetElement() {
        return this.getPsiElement();
    }

    public final boolean isValid() {
        return this.getEnclosingElement() != null;
    }

    public final boolean update() {
        boolean polymorphicCall;
        OCQualifiedName qualifiedName;
        OCSymbolWithParent symbol;
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldIcon = this.getIcon();
        boolean changes = super.update();
        OCCallable enclosingElement = this.getEnclosingElement();
        if (enclosingElement == null) {
            return this.invalidElement();
        }
        this.installIcon(enclosingElement, changes);
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        String name2 = null;
        if (enclosingElement instanceof OCMethod) {
            symbol = (OCMethodSymbol)((OCMethod)enclosingElement).getSymbol();
            name2 = symbol != null ? symbol.getNameWithParent(OCResolveContext.forPsi(enclosingElement)) : ((OCMethod)enclosingElement).getName();
        } else if (enclosingElement instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)enclosingElement).getSymbol()) != null && (qualifiedName = symbol.getResolvedQualifiedName(OCResolveContext.forPsi(enclosingElement))) != null) {
            name2 = qualifiedName.getNameWithParent();
        }
        if (name2 == null) {
            ItemPresentation presentation = ((NavigatablePsiElement)enclosingElement).getPresentation();
            name2 = presentation != null ? presentation.getPresentableText() : ((NavigatablePsiElement)enclosingElement).getName();
        }
        this.myHighlightedText.getEnding().addText(name2, mainTextAttributes);
        boolean bl = polymorphicCall = this.myPossibleResponders.size() > 1;
        if (polymorphicCall) {
            this.myHighlightedText.getEnding().addText(" (polymorphic call) ", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        if (this.myUsageCount > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.myUsageCount}), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
    }

    public void navigate(boolean requestFocus) {
        if (!this.myNavigateToReference) {
            PsiElement element = this.getPsiElement();
            if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
                ((Navigatable)element).navigate(requestFocus);
            }
            return;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement element = firstReference.getElement();
        if (element == null) {
            return;
        }
        PsiElement callElement = element.getParent();
        if (callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate()) {
            ((Navigatable)callElement).navigate(requestFocus);
        } else {
            PsiFile psiFile = callElement.getContainingFile();
            if (psiFile == null || psiFile.getVirtualFile() == null) {
                return;
            }
            FileEditorManager.getInstance((Project)this.myProject).openFile(psiFile.getVirtualFile(), requestFocus);
        }
        Editor editor = PsiUtilBase.findEditor((PsiElement)callElement);
        if (editor != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            ArrayList highlighters = new ArrayList();
            for (PsiReference psiReference : this.myReferences) {
                PsiElement eachMethodCall;
                PsiElement eachElement = psiReference.getElement();
                if (eachElement == null || (eachMethodCall = eachElement.getParent()) == null) continue;
                TextRange textRange = eachMethodCall.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, false, highlighters);
            }
        }
    }

    public boolean canNavigate() {
        PsiFile psiFile;
        if (!this.myNavigateToReference) {
            PsiElement element = this.getPsiElement();
            return element instanceof Navigatable && ((Navigatable)element).canNavigate();
        }
        if (this.myReferences.isEmpty()) {
            return false;
        }
        PsiReference firstReference = this.myReferences.get(0);
        PsiElement callElement = firstReference.getElement().getParent();
        if (callElement == null || !callElement.isValid()) {
            return false;
        }
        return callElement instanceof Navigatable && ((Navigatable)callElement).canNavigate() || (psiFile = callElement.getContainingFile()) != null;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }
}

