/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeAggregator;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCFunctionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class OCCalleeMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public OCCalleeMethodsTreeStructure(Project project2, OCCallable method, String scopeType) {
        super(project2, (HierarchyNodeDescriptor)new OCCallHierarchyNodeDescriptor(project2, null, OCCalleeMethodsTreeStructure.getImplementationOfMethod(method), true, false));
        this.myScopeType = scopeType;
    }

    private static OCCallable getImplementationOfMethod(OCCallable method) {
        OCSymbol symbol = method.getSymbol();
        if (symbol != null && symbol.isPredeclaration()) {
            PsiElement implElement;
            OCSymbol impl = symbol.getDefinitionSymbol(method.getProject());
            if (impl != null) {
                symbol = impl;
            }
            if ((implElement = symbol.locateDefinition(method.getProject())) instanceof OCCallable) {
                method = (OCCallable)implElement;
            }
            if (implElement != null && implElement.getParent() instanceof OCCallable) {
                method = (OCCallable)implElement.getParent();
            }
        }
        return method;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        OCBlockStatement body;
        OCCallHierarchyNodeDescriptor nodeDescriptor = (OCCallHierarchyNodeDescriptor)descriptor2;
        if (nodeDescriptor.getPossibleResponders().size() > 1) {
            ArrayList<OCCallHierarchyNodeDescriptor> result = new ArrayList<OCCallHierarchyNodeDescriptor>();
            for (OCSymbol symbol : nodeDescriptor.getPossibleResponders()) {
                PsiElement element;
                OCSymbol impl;
                if (symbol.isPredeclaration() && (impl = symbol.getDefinitionSymbol(this.myProject)) != null) {
                    symbol = impl;
                }
                if ((element = symbol.locateDefinition(this.myProject)) == null) continue;
                result.add(new OCCallHierarchyNodeDescriptor(this.myProject, descriptor2, element, false, false));
            }
            return result.toArray();
        }
        ChildrenCalculator calculator = new ChildrenCalculator(nodeDescriptor);
        OCCallable enclosingElement = nodeDescriptor.getEnclosingElement();
        if (enclosingElement != null && (body = (enclosingElement = OCCalleeMethodsTreeStructure.getImplementationOfMethod(enclosingElement)).getBody()) != null) {
            calculator.visit(body);
        }
        return calculator.getChildren();
    }

    private class ChildrenCalculator
    extends OCCallHierarchyNodeAggregator {
        private final boolean myParentIsConstructorDestructor;

        private ChildrenCalculator(OCCallHierarchyNodeDescriptor parentDescriptor) {
            OCFunctionSymbol function;
            OCSymbol symbol;
            super(parentDescriptor);
            OCCallable parent = parentDescriptor.getEnclosingElement();
            this.myParentIsConstructorDestructor = parent != null ? ((symbol = parent.getSymbol()) instanceof OCFunctionSymbol ? (function = (OCFunctionSymbol)symbol).isCppConstructor() || function.isCppDestructor() : false) : false;
        }

        private void visit(PsiElement element) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                String selectorName;
                OCCallHierarchyNodeDescriptor desc;
                OCMethodSymbol impl;
                OCSymbol known;
                this.visit(child);
                if (child instanceof OCReferenceElement) {
                    PsiElement parent = child.getParent().getParent();
                    if (!(parent instanceof OCCallExpression) && !(parent instanceof OCCppNewExpression) || !((known = ((OCReferenceElement)child).resolveToSymbol()) instanceof OCFunctionSymbol)) continue;
                    boolean isVirtual = !this.myParentIsConstructorDestructor && ((OCReferenceElement)child).getNamespaceQualifier() == null;
                    this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                    continue;
                }
                if (child instanceof OCQualifiedExpression) {
                    known = ((OCQualifiedExpression)child).resolveToSymbol();
                    if (known instanceof OCMethodSymbol) {
                        this.processMethodSymbol((OCMethodSymbol)known, (OCElement)child);
                        continue;
                    }
                    if (child.getParent() instanceof OCCallExpression && known instanceof OCFunctionSymbol) {
                        boolean isVirtual = !this.myParentIsConstructorDestructor && OCFunctionReferenceSearch.isCallViaReference(((OCQualifiedExpression)child).getQualifier());
                        this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                        continue;
                    }
                    if (!(known instanceof OCPropertySymbol)) continue;
                    OCPropertySymbol property = (OCPropertySymbol)known;
                    ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(child);
                    property.getParent().processMembers(OCMethodSymbol.class, method -> {
                        if (method.getGeneratedFromProperty() == property) {
                            OCResolveContext context = OCResolveContext.forPsi(element);
                            if (access == ReadWriteAccessDetector.Access.Read && method.isGetter(context) || access == ReadWriteAccessDetector.Access.Write && method.isSetter(context) || access == ReadWriteAccessDetector.Access.ReadWrite) {
                                this.processMethodSymbol((OCMethodSymbol)method, (OCElement)child);
                            }
                        }
                        return true;
                    });
                    continue;
                }
                if (!(child instanceof OCSendMessageExpression)) continue;
                OCSendMessageExpression callExpression = (OCSendMessageExpression)child;
                OCSendMessageExpression.ProbableResponders responders = callExpression.getProbableResponders();
                OCObjectTypeContext receiverContext = callExpression.getReceiverContext();
                if (receiverContext == null) continue;
                OCMethodSymbol known2 = responders.getKnownResponder();
                if (known2 != null && !known2.isDefinition() && (impl = known2.getDefinitionSymbol(OCCalleeMethodsTreeStructure.this.myProject)) != null) {
                    known2 = impl;
                }
                if ((desc = this.addNodeDescriptor(known2, selectorName = callExpression.getMessageSelector(), (OCElement)child)) == null) continue;
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(selectorName, receiverContext.getType().getClassSymbol(), OCCalleeMethodsTreeStructure.this.myProject, OCMethodSymbol.class, receiverContext.getStaticMode());
                this.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (receiverContext.fitsStaticness((OCMemberSymbol)symbol) && symbol.isDefinition()) {
                        desc.addPossibleResponder((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private void processMethodSymbol(OCMethodSymbol known, OCElement context) {
            OCCallHierarchyNodeDescriptor desc;
            OCMethodSymbol impl;
            if (!known.isDefinition() && (impl = known.getDefinitionSymbol(OCCalleeMethodsTreeStructure.this.myProject)) != null) {
                known = impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context)) != null) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(known, OCCalleeMethodsTreeStructure.this.myProject);
                this.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (symbol.isDefinition()) {
                        desc.addPossibleResponder((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private void processFunctionSymbol(OCFunctionSymbol known, OCElement context, boolean virtualCall) {
            OCCallHierarchyNodeDescriptor desc;
            OCSymbol impl;
            if (known.isPredeclaration() && (impl = known.getDefinitionSymbol(OCCalleeMethodsTreeStructure.this.myProject)) instanceof OCFunctionSymbol) {
                known = (OCFunctionSymbol)impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context)) != null && virtualCall && OCFunctionAncestorsQuery.findFirstVirtual(known, true, OCCalleeMethodsTreeStructure.this.myProject) != null) {
                OCFile file = context.getContainingOCFile();
                OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters(known, file, true);
                HashSet names = new HashSet();
                parameters.setImplementationsThenPredeclarations(true);
                parameters.setIncludeSameSymbols(true);
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                OCFunctionInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (names.add(symbol.getResolvedQualifiedName(resolveContext))) {
                        desc.addPossibleResponder((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private void setSearchParameters(OCMemberInheritorsSearch.SearchParameters parameters) {
            parameters.setIncludeSelfImplementation(true);
            parameters.setInterfacesThenImplementations(false);
            parameters.setIncludeFromID(true);
            parameters.setInheritors(true);
            parameters.setAncestors(false);
        }
    }
}

