/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.include;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportSuperHierarchyTreeStructure
extends HierarchyTreeStructure {
    private static final HierarchyNodeDescriptor[] EMPTY_DESCRIPTORS = new HierarchyNodeDescriptor[0];
    private static final boolean DISPLAY_LOCATION = !ApplicationManager.getApplication().isUnitTestMode();

    public OCImportSuperHierarchyTreeStructure(@NotNull Project project2, @NotNull OCFile file) {
        super(project2, OCImportSuperHierarchyTreeStructure.createDescriptor(project2, null, file, true));
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor nodeDescriptor) {
        OCClassHierarchyNodeDescriptor descriptor2 = (OCClassHierarchyNodeDescriptor)nodeDescriptor;
        OCFile file = (OCFile)descriptor2.getType();
        FileSymbolTablesCache.getInstance(this.myProject).ensurePendingFilesProcessed();
        if (file == null) {
            return EMPTY_DESCRIPTORS;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return EMPTY_DESCRIPTORS;
        }
        List answer = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)this.myProject), OCImportGraph.findImmediateIncludingFiles(this.myProject, vFile, false));
        Object[] descriptors = new HierarchyNodeDescriptor[answer.size()];
        int i = 0;
        for (PsiFile superFile : answer) {
            descriptors[i] = OCImportSuperHierarchyTreeStructure.createDescriptor(this.myProject, descriptor2, superFile, false);
            ++i;
        }
        return descriptors;
    }

    @NotNull
    private static HierarchyNodeDescriptor createDescriptor(@NotNull Project project2, @Nullable OCClassHierarchyNodeDescriptor<OCFile> parent, @NotNull PsiFile superFile, boolean isBase) {
        return new OCClassHierarchyNodeDescriptor<PsiFile>(project2, parent, superFile, isBase, DISPLAY_LOCATION);
    }
}

