/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.include;

import com.intellij.icons.AllIcons;
import com.intellij.ide.hierarchy.ChangeHierarchyViewActionBase;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.include.OCImportSubHierarchyTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.include.OCImportSuperHierarchyTreeStructure;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeHierarchyBrowser
extends HierarchyBrowserBaseEx {
    private static final Logger LOG = Logger.getInstance(OCIncludeHierarchyBrowser.class);
    public static final String INCLUDING_HIERARCHY_TYPE = OCBundle.message("navigation.import.hierarchy.including.title", new Object[0]);
    public static final String INCLUDED_BY_HIERARCHY_TYPE = OCBundle.message("navigation.import.hierarchy.included.title", new Object[0]);
    public static final DataKey<OCIncludeHierarchyBrowser> DATA_KEY = DataKey.create((String)"com.jetbrains.cidr.lang.hierarchy.include.OCIncludeHierarchyBrowser");
    private boolean myIsImplementation;

    public OCIncludeHierarchyBrowser(@NotNull Project project2, @NotNull OCFile file) {
        super(project2, (PsiElement)file);
    }

    public boolean isImplementation() {
        return this.myIsImplementation;
    }

    protected void setHierarchyBase(@NotNull PsiElement element) {
        super.setHierarchyBase(element);
        this.myIsImplementation = element instanceof OCFile && !OCInclusionContextUtil.isNeedToFindRoot((OCFile)element);
    }

    @Nullable
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (!(descriptor2 instanceof OCClassHierarchyNodeDescriptor)) {
            return null;
        }
        return ((OCClassHierarchyNodeDescriptor)descriptor2).getType();
    }

    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        return OCBundle.message("navigation.import.hierarchy.previous.occurence", new Object[0]);
    }

    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        return OCBundle.message("navigation.import.hierarchy.next.occurence", new Object[0]);
    }

    @NotNull
    protected String getBrowserDataKey() {
        return DATA_KEY.getName();
    }

    @NotNull
    protected String getActionPlace() {
        return "TypeHierarchyViewToolbar";
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        return element instanceof OCFile;
    }

    @Nullable
    protected Comparator<NodeDescriptor> getComparator() {
        return AlphaComparator.INSTANCE;
    }

    @Nullable
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement element) {
        if (element instanceof OCFile) {
            if (INCLUDED_BY_HIERARCHY_TYPE.equals(typeName)) {
                return new OCImportSubHierarchyTreeStructure(this.myProject, (OCFile)element);
            }
            return new OCImportSuperHierarchyTreeStructure(this.myProject, (OCFile)element);
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    protected void createTrees(@NotNull Map<String, JTree> trees) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        JTree tree1 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)actionManager);
        trees.put(INCLUDING_HIERARCHY_TYPE, tree1);
        JTree tree2 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)actionManager);
        trees.put(INCLUDED_BY_HIERARCHY_TYPE, tree2);
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        actionGroup.add((AnAction)new ViewIncludedHierarchyAction());
        actionGroup.add((AnAction)new ViewIncludingHierarchyAction());
        super.prependActions(actionGroup);
    }

    private static abstract class ChangeViewAction
    extends ChangeHierarchyViewActionBase {
        ChangeViewAction(String text, String description, Icon icon) {
            super(text, description, icon);
        }

        protected OCIncludeHierarchyBrowser getHierarchyBrowser(DataContext context) {
            return (OCIncludeHierarchyBrowser)((Object)DATA_KEY.getData(context));
        }
    }

    static class ViewIncludingHierarchyAction
    extends ChangeViewAction {
        ViewIncludingHierarchyAction() {
            super(OCBundle.message("navigation.import.hierarchy.including.action", new Object[0]), OCBundle.message("navigation.import.hierarchy.including.action.description", new Object[0]), AllIcons.Hierarchy.Supertypes);
        }

        protected String getTypeName() {
            return INCLUDING_HIERARCHY_TYPE;
        }
    }

    static class ViewIncludedHierarchyAction
    extends ChangeViewAction {
        ViewIncludedHierarchyAction() {
            super(OCBundle.message("navigation.import.hierarchy.included.action", new Object[0]), OCBundle.message("navigation.import.hierarchy.included.action.description", new Object[0]), AllIcons.Hierarchy.Subtypes);
        }

        protected String getTypeName() {
            return INCLUDED_BY_HIERARCHY_TYPE;
        }
    }
}

