/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.oc;

import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotTypeStructureProvider;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeStructureProvider
implements PolyglotTypeStructureProvider {
    @Override
    @Nullable
    public PsiElement getSuperClass(@NotNull PsiElement declaration) {
        if (declaration instanceof OCProtocol) {
            return null;
        }
        OCObjectType type = ((OCClassDeclaration)declaration).getType();
        if (type == null) {
            return null;
        }
        OCObjectType superType = type.getSuperType();
        if (superType == null) {
            return null;
        }
        OCClassSymbol superSymbol = superType.getClassSymbol();
        if (superSymbol == null) {
            return null;
        }
        return superSymbol.locateDefinition(declaration.getProject());
    }

    @Override
    @NotNull
    public List<? extends PsiElement> getSuperTypes(@NotNull PsiElement declaration) {
        OCClassDeclaration aClass = (OCClassDeclaration)declaration;
        OCObjectType type = aClass.getType();
        if (type == null) {
            return Collections.emptyList();
        }
        OCObjectType superType = type.getSuperType();
        ArrayList<PsiElement> answer = new ArrayList<PsiElement>();
        if (superType != null) {
            OCTypeStructureProvider.appendSymbol(answer, superType.getClassSymbol(), declaration.getProject());
        }
        Project project2 = declaration.getProject();
        if (aClass instanceof OCProtocol) {
            OCTypeStructureProvider.appendProtocols(answer, aClass.getSymbol(), project2, aClass);
        } else {
            OCTypeStructureProvider.appendProtocols(answer, type.getClassSymbol(), project2, aClass);
        }
        for (OCInterfaceSymbol category : type.getCategoryInterfaces()) {
            OCTypeStructureProvider.appendProtocols(answer, category, project2, aClass);
        }
        return answer;
    }

    private static void appendSymbol(@NotNull List<PsiElement> answer, @Nullable OCSymbol symbol, @NotNull Project project2) {
        PsiElement def;
        if (symbol != null && (def = symbol.locateDefinition(project2)) != null) {
            answer.add(def);
        }
    }

    private static void appendProtocols(@NotNull List<PsiElement> answer, @Nullable OCClassSymbol symbol, @NotNull Project project2, @NotNull OCClassDeclaration aClass) {
        if (symbol != null) {
            for (String protocolName : symbol.getProtocolNames()) {
                CommonProcessors.FindFirstProcessor resolver = new CommonProcessors.FindFirstProcessor();
                OCResolveUtil.processGlobalSymbols(protocolName, aClass, new OCCommonProcessors.TypeFilteredProcessor((Processor<OCProtocolSymbol>)resolver, OCProtocolSymbol.class));
                if (!resolver.isFound()) continue;
                OCTypeStructureProvider.appendSymbol(answer, (OCSymbol)resolver.getFoundValue(), project2);
            }
        }
    }

    @Override
    @NotNull
    public List<? extends PsiElement> getInheritors(@NotNull PsiElement declaration) {
        Project project2 = declaration.getProject();
        Collection symbols = OCDirectInheritorsSearch.search((OCClassDeclaration)declaration).findAll();
        return symbols.stream().map(symbol -> symbol.locateDefinition(project2)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public PolyglotHierarchyNodeDescriptor createNodeDescriptor(@NotNull PsiElement declaration, @Nullable PolyglotHierarchyNodeDescriptor parent, boolean isBase) {
        return new OCClassHierarchyNodeDescriptor<OCClassDeclaration>(declaration.getProject(), parent, (OCClassDeclaration)declaration, isBase);
    }

    @Override
    public boolean isTypeHierarchyAvailable(@NotNull PsiElement element) {
        return element instanceof OCClassDeclaration;
    }

    @Override
    @Nullable
    public String getHierarchyType(@NotNull PsiElement base) {
        if (base instanceof OCProtocol) {
            return TypeHierarchyBrowserBase.SUBTYPES_HIERARCHY_TYPE;
        }
        return TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE;
    }

    @Override
    @NotNull
    public String getQualifiedName(@NotNull PsiElement element) {
        if (element instanceof OCClassDeclaration) {
            return ((OCClassDeclaration)element).getCanonicalName();
        }
        return "";
    }

    @Override
    public boolean isInterface(@NotNull PsiElement element) {
        return element instanceof OCProtocol;
    }
}

