/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hmap;

import com.intellij.util.io.Bits;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapsHelpersKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0013\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 &2\u00020\u0001:\u0001&B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B=\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/lang/hmap/Header;", "", "numEntries", "", "numBuckets", "maxValueLength", "(III)V", "rawMagic", "rawVersion", "", "rawReserved", "rawStringsOffset", "rawNumEntries", "rawNumBuckets", "rawMaxValueLength", "(ISSIIII)V", "bucketsBytes", "getBucketsBytes", "()I", "getNumEntries", "getRawMagic", "getRawMaxValueLength", "getRawNumBuckets", "getRawNumEntries", "getRawReserved", "()S", "getRawStringsOffset", "getRawVersion", "stringsOffset", "", "getStringsOffset", "()J", "toString", "", "writeTo", "", "buffer", "Ljava/nio/ByteBuffer;", "Companion", "intellij.c"})
public class Header {
    private final int rawMagic;
    private final short rawVersion;
    private final short rawReserved;
    private final int rawStringsOffset;
    private final int rawNumEntries;
    private final int rawNumBuckets;
    private final int rawMaxValueLength;
    private static final int HeaderMagicNumber;
    public static final short HeaderVersion = 1;
    public static final short HeaderReserved = 0;
    public static final int BYTES = 24;
    public static final Companion Companion;

    public final long getStringsOffset() {
        return OCHeaderMapsHelpersKt.asUnsigned(this.rawStringsOffset);
    }

    public final int getNumEntries() {
        return OCHeaderMapsHelpersKt.toIntExact(OCHeaderMapsHelpersKt.asUnsigned(this.rawNumEntries));
    }

    public final int getBucketsBytes() {
        return Header.Companion.getBucketBytes(OCHeaderMapsHelpersKt.asUnsigned(this.rawNumBuckets));
    }

    public final void writeTo(@NotNull ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        ByteBuffer $receiver = byteBuffer = buffer;
        boolean bl = false;
        $receiver.putInt(this.rawMagic);
        $receiver.putShort(this.rawVersion);
        $receiver.putShort(this.rawReserved);
        $receiver.putInt(this.rawStringsOffset);
        $receiver.putInt(this.rawNumEntries);
        $receiver.putInt(this.rawNumBuckets);
        $receiver.putInt(this.rawMaxValueLength);
    }

    @NotNull
    public String toString() {
        return "Header(magic=" + this.rawMagic + ", version=" + this.rawVersion + ", reserved=" + this.rawReserved + ", stringsOffset=" + this.rawStringsOffset + ", numEntries=" + this.rawNumEntries + ", numBuckets=" + this.rawNumBuckets + ", maxValueLength=" + this.rawMaxValueLength + ')';
    }

    public final int getRawMagic() {
        return this.rawMagic;
    }

    public final short getRawVersion() {
        return this.rawVersion;
    }

    public final short getRawReserved() {
        return this.rawReserved;
    }

    public final int getRawStringsOffset() {
        return this.rawStringsOffset;
    }

    public final int getRawNumEntries() {
        return this.rawNumEntries;
    }

    public final int getRawNumBuckets() {
        return this.rawNumBuckets;
    }

    public final int getRawMaxValueLength() {
        return this.rawMaxValueLength;
    }

    public Header(int rawMagic, short rawVersion, short rawReserved, int rawStringsOffset, int rawNumEntries, int rawNumBuckets, int rawMaxValueLength) {
        this.rawMagic = rawMagic;
        this.rawVersion = rawVersion;
        this.rawReserved = rawReserved;
        this.rawStringsOffset = rawStringsOffset;
        this.rawNumEntries = rawNumEntries;
        this.rawNumBuckets = rawNumBuckets;
        this.rawMaxValueLength = rawMaxValueLength;
    }

    public Header(int numEntries, int numBuckets, int maxValueLength) {
        this(HeaderMagicNumber, 1, 0, 24 + Header.Companion.getBucketBytes(numBuckets), numEntries, numBuckets, maxValueLength);
    }

    static {
        Companion = new Companion(null);
        String string = "hmap";
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        HeaderMagicNumber = Bits.getInt((byte[])byArray, (int)0);
    }

    public static final int getHeaderMagicNumber() {
        Companion companion = Companion;
        return HeaderMagicNumber;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002JB\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J)\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/hmap/Header$Companion;", "", "()V", "BYTES", "", "HeaderMagicNumber", "HeaderMagicNumber$annotations", "getHeaderMagicNumber", "()I", "HeaderReserved", "", "HeaderVersion", "getBucketBytes", "numBuckets", "", "parse", "Lcom/jetbrains/cidr/lang/hmap/Header;", "magic", "version", "reserved", "stringsOffset", "numEntries", "maxValueLength", "parseNext", "buffer", "Ljava/nio/ByteBuffer;", "parseNextSniffingByteOrder", "byteOrders", "", "Ljava/nio/ByteOrder;", "(Ljava/nio/ByteBuffer;[Ljava/nio/ByteOrder;)Lcom/jetbrains/cidr/lang/hmap/Header;", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void HeaderMagicNumber$annotations() {
        }

        public final int getHeaderMagicNumber() {
            return HeaderMagicNumber;
        }

        private final int getBucketBytes(long numBuckets) {
            return OCHeaderMapsHelpersKt.toIntExact(Math.multiplyExact(numBuckets, (long)12));
        }

        private final Header parse(int magic, short version, short reserved, int stringsOffset, int numEntries, int numBuckets, int maxValueLength) {
            short s;
            short it = s = magic;
            boolean bl = false;
            if (it != Companion.getHeaderMagicNumber()) {
                return null;
            }
            short s2 = s;
            it = s = (short)version;
            boolean bl2 = false;
            if (it != 1) {
                return null;
            }
            short s3 = s;
            it = s = (short)reserved;
            boolean bl3 = false;
            if (it != 0) {
                return null;
            }
            short s4 = s;
            s = numBuckets;
            int n = numEntries;
            int n2 = stringsOffset;
            it = s;
            boolean bl4 = false;
            if (!OCHeaderMapsHelpersKt.isPowerOfTwo(it)) {
                return null;
            }
            short s5 = s;
            int n3 = maxValueLength;
            short s6 = s5;
            int n4 = n;
            int n5 = n2;
            short s7 = s4;
            short s8 = s3;
            short s9 = s2;
            return new Header(s9, s8, s7, n5, n4, s6, n3);
        }

        private final Header parseNext(ByteBuffer buffer) {
            ByteBuffer byteBuffer;
            ByteBuffer $receiver = byteBuffer = buffer;
            boolean bl = false;
            return Companion.parse($receiver.getInt(), $receiver.getShort(), $receiver.getShort(), $receiver.getInt(), $receiver.getInt(), $receiver.getInt(), $receiver.getInt());
        }

        @Nullable
        public final Header parseNextSniffingByteOrder(@NotNull ByteBuffer buffer, ByteOrder ... byteOrders) {
            ByteBuffer byteBuffer;
            ByteBuffer $receiver = byteBuffer = buffer;
            boolean bl = false;
            $receiver.mark();
            for (ByteOrder byteOrder : byteOrders) {
                $receiver.order(byteOrder);
                Header header = Companion.parseNext(buffer);
                if (header != null) {
                    Header header2;
                    Header it = header2 = header;
                    boolean bl2 = false;
                    return it;
                }
                $receiver.reset();
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

