/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ArgumentSelectionDefectsInspection
extends OurClangTidyInspection {
    public static final String INSPECTION_SHORT_NAME = "ArgumentSelectionDefectsInspection";
    public static final String DISPLAY_NAME = "Argument selection defects";
    public static final String CHECK_NAME = "clion-argument-selection-defects";
    public static final String SHORT_PARAMETERS_NAMES_OPTION = "clion-argument-selection-defects.ShortParametersNames";
    public boolean myAllowShortParametersNames = true;

    @Override
    public String getCheckName() {
        return CHECK_NAME;
    }

    @Override
    @NotNull
    public String getShortName() {
        return INSPECTION_SHORT_NAME;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void createOptionsPanel(@NotNull JPanel panel, @NotNull GridBag bag) {
        panel.add((Component)this.createShortParametersNamesCheckbox(), bag.nextLine());
    }

    @NotNull
    public JComponent createShortParametersNamesCheckbox() {
        final JBCheckBox checkBox = new JBCheckBox("Allow parameters/arguments with short names (less than three symbols)", this.myAllowShortParametersNames);
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ArgumentSelectionDefectsInspection.this.myAllowShortParametersNames = checkBox.isSelected();
                ArgumentSelectionDefectsInspection.this.addOrReplaceCheckOption(ArgumentSelectionDefectsInspection.SHORT_PARAMETERS_NAMES_OPTION, Integer.toString(ArgumentSelectionDefectsInspection.this.myAllowShortParametersNames ? 1 : 0));
            }
        });
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)checkBox);
        return panel;
    }

    public boolean isAllowShortParametersNames() {
        return this.myAllowShortParametersNames;
    }

    public void setAllowShortParametersNames(boolean allowShortParametersNames) {
        this.myAllowShortParametersNames = allowShortParametersNames;
    }
}

