/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyConfigurable;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOptionsButton;
import com.jetbrains.cidr.lang.inspections.ClangTidyChecksOptionsDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyInspection
extends ClangTidyInspectionBase {
    public static final String INSPECTION_SHORT_NAME = "ClangTidyInspection";
    public static final String DISPLAY_NAME = "Clang-Tidy";
    @NotNull
    private String myClangTidyChecks = ClangTidyInspection.getDefaultChecks();
    private boolean myUseCustomListOfClangTidyChecks = true;
    @NotNull
    private static final List<String> DEFAULT_CHECKS_CONFIGURATION = ClangTidyInspection.getDefaultChecksConfiguration();

    @Override
    public boolean isEnabledByDefault() {
        return ClangTidyAnnotator.isAvailable();
    }

    @Override
    @NotNull
    public String getShortName() {
        return INSPECTION_SHORT_NAME;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        builder.addComponent(this.createCheckbox(childPanel));
        int indent = 20;
        ClangTidyInspection.addComponent(this.createChecksField(), childPanel, 0, 2, 0, 1, 0, (Insets)JBUI.insetsLeft((int)indent));
        ClangTidyInspection.addComponent((Component)new JBLabel("Comma-separated list of enabled and disabled checks. ", UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), childPanel, 0, 1, 1, 0, 0, (Insets)JBUI.insetsLeft((int)indent));
        ClangTidyInspection.addComponent((Component)ClangTidyInspection.createChecksExampleLink(), childPanel, 1, 1, 1, 0, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent(this.createOptionsButton(childPanel), childPanel, 0, 2, 2, 1, 1, (Insets)JBUI.insetsLeft((int)indent));
        builder.addComponent((JComponent)childPanel);
        builder.addComponent((JComponent)OCInspectionUtil.createLinkToConfigurable("Specify Clang-Tidy executable", ClangTidyConfigurable.class, null), 10);
        UIUtil.setEnabled((Component)childPanel, (boolean)this.myUseCustomListOfClangTidyChecks, (boolean)true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)builder.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        return isBatchMode ? clangTidyMessage : "Clang-Tidy: " + clangTidyMessage;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName() {
        return this.isUseCustomListOfClangTidyChecks();
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        return clangTidyCheckName;
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        panel.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel("Example");
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://clang.llvm.org/extra/clang-tidy/#using-clang-tidy"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return hint;
    }

    @NotNull
    private JComponent createCheckbox(final @NotNull Component childComponent) {
        final JBCheckBox checkbox = new JBCheckBox("Use IDE settings (skip existing .clang-tidy files):", this.myUseCustomListOfClangTidyChecks);
        checkbox.getInsets().set(0, 0, 0, 0);
        checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClangTidyInspection.this.myUseCustomListOfClangTidyChecks = checkbox.isSelected();
                UIUtil.setEnabled((Component)childComponent, (boolean)checkbox.isSelected(), (boolean)true);
            }
        });
        return checkbox;
    }

    @NotNull
    private JComponent createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.setText(this.myClangTidyChecks);
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ClangTidyInspection.this.myClangTidyChecks = checksEditor.getText();
            }
        });
        return checksEditor;
    }

    @NotNull
    private JComponent createOptionsButton(final @NotNull Component component) {
        final ClangTidyCheckOptionsButton checkOptionsButton = new ClangTidyCheckOptionsButton("Configure Clang-Tidy Checks Options...");
        checkOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List checkOptions = ClangTidyInspection.this.myClangTidyCheckOptions;
                ClangTidyChecksOptionsDialog optionsDialog = new ClangTidyChecksOptionsDialog(component, checkOptions);
                optionsDialog.showAndGet();
                if (!ClangTidyInspection.this.myClangTidyCheckOptions.equals(checkOptions)) {
                    ClangTidyInspection.this.myClangTidyCheckOptions = checkOptions;
                    checkOptionsButton.fireStateChanged();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)checkOptionsButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ClangTidyAnnotator annotator = new ClangTidyAnnotator(this);
        return ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)isOnTheFly, (ExternalAnnotator)annotator);
    }

    public boolean isUseCustomListOfClangTidyChecks() {
        return this.myUseCustomListOfClangTidyChecks;
    }

    public void setUseCustomListOfClangTidyChecks(boolean useCustomListOfClangTidyChecks) {
        this.myUseCustomListOfClangTidyChecks = useCustomListOfClangTidyChecks;
    }

    @NotNull
    public String getClangTidyChecks() {
        return !this.myClangTidyChecks.isEmpty() ? this.myClangTidyChecks : ClangTidyInspection.getAllDisabledChecks();
    }

    public void setClangTidyChecks(@NotNull String clangTidyChecks) {
        this.myClangTidyChecks = clangTidyChecks;
    }

    @NotNull
    public static String getDefaultChecks() {
        return StringUtil.join(DEFAULT_CHECKS_CONFIGURATION, (String)",");
    }

    @NotNull
    public static String getAllEnabledChecks() {
        return "*";
    }

    @NotNull
    public static String getAllEnabledChecksExceptClangAnalyzer() {
        return "*,-clang-analyzer-*";
    }

    @NotNull
    public static String getAllDisabledChecks() {
        return "-*";
    }

    private static List<String> getDefaultChecksConfiguration() {
        List<String> configuration = Arrays.asList("*", "-android-*", "-bugprone-bool-pointer-implicit-conversion", "-bugprone-exception-escape", "-cert-env33-c", "-cert-dcl50-cpp", "-cert-dcl59-cpp", "-cppcoreguidelines-avoid-goto", "-cppcoreguidelines-avoid-magic-numbers", "-cppcoreguidelines-no-malloc", "-cppcoreguidelines-owning-memory", "-cppcoreguidelines-pro-bounds-array-to-pointer-decay", "-cppcoreguidelines-pro-bounds-constant-array-index", "-cppcoreguidelines-pro-bounds-pointer-arithmetic", "-cppcoreguidelines-pro-type-const-cast", "-cppcoreguidelines-pro-type-cstyle-cast", "-cppcoreguidelines-pro-type-reinterpret-cast", "-cppcoreguidelines-pro-type-union-access", "-cppcoreguidelines-pro-type-vararg", "-cppcoreguidelines-special-member-functions", "-fuchsia-*", "-google-*", "google-default-arguments", "google-explicit-constructor", "google-runtime-operator", "-hicpp-avoid-goto", "-hicpp-braces-around-statements", "-hicpp-named-parameter", "-hicpp-no-array-decay", "-hicpp-no-assembler", "-hicpp-no-malloc", "-hicpp-function-size", "-hicpp-special-member-functions", "-hicpp-vararg", "-llvm-*", "-objc-*", "-readability-else-after-return", "-readability-implicit-bool-conversion", "-readability-magic-numbers", "-readability-named-parameter", "-readability-simplify-boolean-expr", "-readability-braces-around-statements", "-readability-identifier-naming", "-readability-function-size", "-readability-redundant-member-init", "-misc-bool-pointer-implicit-conversion", "-misc-definitions-in-headers", "-misc-unused-alias-decls", "-misc-unused-parameters", "-misc-unused-using-decls", "-modernize-use-using", "-modernize-use-default-member-init", "-clang-diagnostic-*", "-clang-analyzer-*", "-zircon-*");
        return ContainerUtil.newUnmodifiableList(configuration);
    }
}

