/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInconsistentNamingInspection
extends OCInspections.GeneralCpp {
    public static final Key<Boolean> INCONSISTENT_NAMING_UNIT_TEST_MODE = Key.create((String)"INCONSISTENT_NAMING_UNIT_TEST_MODE");

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Inconsistent Naming";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WEAK_WARNING;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    protected boolean worksWithClangd() {
        return true;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultWeightX(1.0).setDefaultWeightY(1.0).setDefaultInsets((Insets)JBUI.insets((int)5)).setDefaultAnchor(18);
        panel.add((Component)OCInspectionUtil.createLinkToConfigurable("Edit Code Style Settings", CodeStyleConfigurableWrapper.class, c -> ((CodeStyleConfigurableWrapper)c).getOriginalClass() == OCCodeStyleSettingsProvider.class), bag.nextLine());
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        if (ApplicationManager.getApplication().isUnitTestMode() && file.getUserData(INCONSISTENT_NAMING_UNIT_TEST_MODE) != Boolean.TRUE && holder.getProject().getUserData(INCONSISTENT_NAMING_UNIT_TEST_MODE) != Boolean.TRUE) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return file instanceof OCFile && ((OCFile)file).isInProjectSources() ? new Visitor((OCFile)file, holder) : PsiElementVisitor.EMPTY_VISITOR;
    }

    private static String getInspectionMessage(@NotNull String suggestedName) {
        return "Rename to " + StringUtil.wrapWithDoubleQuote((String)suggestedName);
    }

    private static String getRenameHeaderGuardMessage(@NotNull String suggestedHeaderGuardName) {
        return "Rename header guard to " + StringUtil.wrapWithDoubleQuote((String)suggestedHeaderGuardName);
    }

    static class RenameElementFix
    extends OCPsiElementQuickFix<PsiElement> {
        @NotNull
        private final String myNewName;
        @NotNull
        private final String myMessage;

        RenameElementFix(@NotNull PsiElement elementToRename, @NotNull String newName, @NotNull String message) {
            super(elementToRename);
            this.myNewName = newName;
            this.myMessage = message;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return this.myMessage;
        }

        @Override
        protected String getTextInternal() {
            return this.myMessage;
        }

        @Override
        protected void invoke(PsiFile file, @NotNull PsiElement element) {
            Editor editor = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            OCInplaceRenamer renamer = (OCInplaceRenamer)new OCInplaceRenameHandler().createRenamer(element, editor);
            if (renamer != null) {
                renamer.performRenameInner(element, this.myNewName);
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }
    }

    private class Visitor
    extends OCVisitor {
        private final ProblemsHolder myHolder;
        private final OCHeaderGuardInfo myHeaderGuardInfo;

        Visitor(@NotNull OCFile file, ProblemsHolder holder) {
            this.myHeaderGuardInfo = ApplicationManager.getApplication().isUnitTestMode() || file.isHeader() ? OCHeaderGuardUtil.findCachedHeaderGuard(file, true) : null;
            this.myHolder = holder;
        }

        @Override
        public void visitDeclarator(OCDeclarator declarator) {
            this.validateNamingConvention(declarator.getName(), declarator, declarator.getNameIdentifier());
        }

        @Override
        public void visitNamespace(OCCppNamespace namespace) {
            this.validateNamingConvention(namespace.getName(), namespace, namespace.getNameIdentifier());
        }

        @Override
        public void visitStructLike(OCStructLike struct) {
            this.validateNamingConvention(struct.getName(), struct, struct.getNameIdentifier());
        }

        @Override
        public void visitDefineDirective(OCDefineDirectiveImpl directive) {
            if (this.myHeaderGuardInfo != null && this.myHeaderGuardInfo.getDefineDirective() == directive) {
                this.validateHeaderGuardStylePattern(directive);
            } else {
                this.validateNamingConvention(directive.getName(), directive, directive.getNameIdentifier());
            }
        }

        private void validateNamingConvention(@Nullable String name2, @NotNull OCSymbolDeclarator<?> symbolDeclarator, @Nullable PsiElement nameIdentifier) {
            String suggestedName;
            OCResolveContext resolveContext;
            Object symbol = symbolDeclarator.getSymbol();
            if (symbol == null || OCNamingConventionUtil.shouldIgnoreNamingConventionForSymbol(symbol) || StringUtil.isEmpty((String)name2) || nameIdentifier == null) {
                return;
            }
            Project project2 = symbolDeclarator.getProject();
            OCSymbolKind symbolKind = symbol.getKind();
            if (!OCNamingConventionUtil.matchesToNamingConvention(name2, symbolKind, symbol, resolveContext = OCResolveContext.forSymbol(symbol, project2), project2) && !(suggestedName = OCNamingConventionUtil.applyNamingConvention(name2, symbolKind, symbol, resolveContext, project2)).isEmpty()) {
                String message = OCInconsistentNamingInspection.getInspectionMessage(suggestedName);
                OCInconsistentNamingInspection.this.registerProblem(this.myHolder, null, null, this.myHolder.isOnTheFly(), nameIdentifier, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RenameElementFix(symbolDeclarator, suggestedName, message));
            }
        }

        private void validateHeaderGuardStylePattern(@NotNull OCDefineDirective defineDirective) {
            PsiFile file = defineDirective.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            String filePath2 = virtualFile.getPath();
            Project project2 = this.myHolder.getProject();
            if (!OCHeaderGuardUtil.headerGuardMatchesPattern(this.myHeaderGuardInfo.getHeaderGuardName(), filePath2, project2)) {
                String suggestedHeaderGuardName = OCHeaderGuardUtil.buildHeaderGuardName(filePath2, project2);
                PsiElement macroReference = PsiTreeUtil.findChildOfType((PsiElement)this.myHeaderGuardInfo.getBeginIfndefDirective(), OCMacroReferenceElementImpl.class);
                if (StringUtil.isNotEmpty((String)suggestedHeaderGuardName) && macroReference != null) {
                    String message = OCInconsistentNamingInspection.getRenameHeaderGuardMessage(suggestedHeaderGuardName);
                    OCInconsistentNamingInspection.this.registerProblem(this.myHolder, null, null, this.myHolder.isOnTheFly(), macroReference, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RenameElementFix(defineDirective, suggestedHeaderGuardName, message));
                }
            }
        }
    }
}

