/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionToolWrapperWithHint;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdConfigurable;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCInspection
extends LocalInspectionTool
implements InspectionToolWrapperWithHint {
    public static final Key<ProblemDescriptionsProcessor> TEST_PROBLEMS_PROCESSOR_KEY = Key.create((String)"TEST_PROBLEMS_PROCESSOR_KEY");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return OCCodeInsightUtil.getPrettyNameFromClassName(((Object)((Object)this)).getClass().getSuperclass());
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return OCCodeInsightUtil.getPrettyNameFromClassName(((Object)((Object)this)).getClass());
    }

    @NotNull
    public String getShortName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return this instanceof OCInspections.Hidden ? HighlightDisplayLevel.NON_SWITCHABLE_ERROR : super.getDefaultLevel();
    }

    protected void registerProblems(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, List<? extends PsiElement> elements, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        for (PsiElement psiElement : elements) {
            if (psiElement.getTextLength() <= 0) continue;
            this.registerProblem(holder, processor2, globalContext, isOnTheFly, psiElement, message, clangID, highlightType, quickFixes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable PsiElement element, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        OCMacroRange range;
        if (element == null) {
            return;
        }
        if (element.getTextLength() == 0) {
            range = OCElementUtil.getRangeInMacroCall(element);
            if (range == null) return;
            OCMacroCall macroCall = range.getMacroCall();
            if (macroCall != element.getPrevSibling()) return;
            element = macroCall;
        }
        range = OCElementUtil.getRangeWithMacros(element);
        this.registerProblem(holder, processor2, globalContext, isOnTheFly, element, null, message, clangID, highlightType, (TextRange)range, quickFixes);
    }

    protected void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable OCElementsRange elementsRange, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        if (elementsRange == null) {
            return;
        }
        TextRange textRange = elementsRange.getTextRange();
        if (textRange.isEmpty()) {
            return;
        }
        this.registerProblem(holder, processor2, globalContext, isOnTheFly, elementsRange.getFirstElement(), elementsRange.getLastElement(), message, clangID, highlightType, textRange, quickFixes);
    }

    private void registerProblem(ProblemsHolder holder, ProblemDescriptionsProcessor processor2, GlobalInspectionContext globalContext, boolean isOnTheFly, PsiElement startElement, @Nullable PsiElement endElement, String message, String clangID, ProblemHighlightType highlightType, TextRange range, IntentionAction[] quickFixes) {
        while (startElement instanceof OCMacroForeignLeafElement) {
            startElement = startElement.getParent();
        }
        while (endElement instanceof OCMacroForeignLeafElement) {
            endElement = endElement.getParent();
        }
        if (endElement != null && startElement.getTextOffset() >= endElement.getTextRange().getEndOffset()) {
            return;
        }
        OCFile file = (OCFile)startElement.getContainingFile();
        List wrappers = ContainerUtil.mapNotNull((Object[])quickFixes, action -> action instanceof SuppressIntentionAction ? null : new IntentionWrapper(action, (PsiFile)file));
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, ((Object)((Object)this)).getClass(), clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        InspectionManager manager = InspectionManager.getInstance((Project)startElement.getProject());
        ProblemDescriptor problem = endElement == null ? manager.createProblemDescriptor(startElement, message, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]), highlightType, isOnTheFly, false) : manager.createProblemDescriptor(startElement, endElement, message, highlightType, isOnTheFly, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]));
        if (problemGroup != null) {
            problem.setProblemGroup((ProblemGroup)problemGroup);
            for (IntentionAction fix : quickFixes) {
                if (!(fix instanceof SuppressIntentionAction)) continue;
                problemGroup.addSuppressAction((SuppressIntentionAction)fix);
            }
        }
        if (processor2 == null) {
            ProblemDescriptionsProcessor problemDescriptionsProcessor = processor2 = file != null ? (ProblemDescriptionsProcessor)file.getProject().getUserData(TEST_PROBLEMS_PROCESSOR_KEY) : null;
        }
        if (processor2 != null) {
            processor2.addProblemElement((RefEntity)(globalContext != null ? GlobalInspectionContextUtil.retrieveRefElement((PsiElement)startElement, (GlobalInspectionContext)globalContext) : null), new CommonProblemDescriptor[]{problem});
        }
        if (holder != null) {
            holder.registerProblem(problem);
        }
    }

    public String getMainToolId() {
        if (OCInspections.class.equals(((Object)((Object)this)).getClass().getDeclaringClass())) {
            return new DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection().getShortName();
        }
        return null;
    }

    protected boolean worksWithClangd() {
        return false;
    }

    public String getHint() {
        return this.worksWithClangd() || !PlatformUtils.isCLion() ? null : "(Adjustable only when clangd is off)";
    }

    public JComponent createOptionsPanel() {
        if (this.worksWithClangd() || !PlatformUtils.isCLion()) {
            return super.createOptionsPanel();
        }
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JBLabel("Note, the inspection is adjustable only when clangd is off"), bag.nextLine().nextLine().insets((Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0)));
        panel.add((Component)new JBLabel("or in Objective C code"), bag.nextLine().nextLine().insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
        panel.add((Component)OCInspection.createOpenClangdSettingsHyperlink(), bag.nextLine().weighty(1.0).insets((Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0)));
        return panel;
    }

    @NotNull
    public static HyperlinkLabel createOpenClangdSettingsHyperlink() {
        final HyperlinkLabel hyperlink = new HyperlinkLabel("Open Clangd settings");
        hyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlink);
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project2 != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project2, ClangdConfigurable.class);
                }
            }
        });
        return hyperlink;
    }

    public static abstract class Cpp
    extends OCInspection {
        @NotNull
        public String[] getGroupPath() {
            return new String[]{"C/C++", this.getGroupDisplayName()};
        }
    }

    public static abstract class ObjC
    extends OCInspection {
        @NotNull
        public String[] getGroupPath() {
            return new String[]{"Objective-C", this.getGroupDisplayName()};
        }
    }
}

