/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.inspections.NotImplementedFunctions;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.inspections.OCInconsistentNamingInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCLegacyObjCLiteralInspection;
import com.jetbrains.cidr.lang.inspections.OCLoopDoesntUseConditionVariableInspection;
import com.jetbrains.cidr.lang.inspections.OCNotLocalizedStringInspection;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.inspections.OCSimplifyInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedClassInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedGlobalDeclarationInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedInstanceVariableInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedMacroInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedMethodInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedPropertyInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedStructInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedTemplateParameterInspection;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInspectionToolProvider
implements InspectionToolProvider {
    private static final ExtensionPointName<NotNullProducer<List<Class>>> STANDALONE_INSPECTIONS_PROVIDER = ExtensionPointName.create((String)"cidr.lang.standaloneInspectionToolProvider");
    private List<Class> myAllInspectionClasses = new ArrayList<Class>();
    private Map<String, Class> myNameToInspectionMap = new HashMap<String, Class>();
    private Map<Class, String> myFakeInspectionsToNameMap = new HashMap<Class, String>();
    private Map<String, Class> myNameToFakeInspectionsMap = new HashMap<String, Class>();
    private Stack<Class> myFakeInspectionsPool = new Stack();
    private static OCInspectionToolProvider instance;

    private OCInspectionToolProvider() {
        for (Class<?> clazz : OCInspections.class.getDeclaredClasses()) {
            if (!Modifier.isPublic(clazz.getModifiers()) || Modifier.isAbstract(clazz.getModifiers()) || !PlatformUtils.isAppCode() && (this.isClangAnalyzerInspection(clazz) || this.isClangCompilerInspection(clazz))) continue;
            this.myAllInspectionClasses.add(clazz);
            try {
                if (this.isClangAnalyzerInspection(clazz)) {
                    this.myFakeInspectionsPool.add(clazz);
                    continue;
                }
                this.myNameToInspectionMap.put(((OCInspection)((Object)clazz.newInstance())).getDisplayName(), clazz);
            }
            catch (InstantiationException e) {
                OCLog.LOG.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                OCLog.LOG.error((Throwable)e);
            }
        }
        this.myAllInspectionClasses.addAll(Arrays.asList(this.getStandaloneInspectionClasses()));
    }

    public static OCInspectionToolProvider getInstance() {
        if (instance == null) {
            instance = new OCInspectionToolProvider();
        }
        return instance;
    }

    @NotNull
    public Class[] getInspectionClasses() {
        return this.myAllInspectionClasses.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    public Class[] getStandaloneInspectionClasses() {
        ArrayList<Class> result = new ArrayList<Class>();
        result.addAll(Arrays.asList(OCGlobalUnusedInspection.class, OCUnusedGlobalDeclarationInspection.class, OCUnusedStructInspection.class, OCUnusedTemplateParameterInspection.class, OCUnusedMacroInspection.class, OCLoopDoesntUseConditionVariableInspection.class, OCSimplifyInspection.class, OCDFAInspection.class, NotImplementedFunctions.class, OCInconsistentNamingInspection.class));
        result.addAll(Arrays.asList(OCUnusedMethodInspection.class, OCUnusedClassInspection.class, OCUnusedInstanceVariableInspection.class, OCUnusedPropertyInspection.class, OCNotReleasedIvarInspection.class, OCNotLocalizedStringInspection.class, OCLegacyObjCLiteralInspection.class));
        for (NotNullProducer each : STANDALONE_INSPECTIONS_PROVIDER.getExtensionList()) {
            result.addAll((Collection)each.produce());
        }
        return result.toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    public boolean isClangCompilerInspection(Class inspectionClass) {
        return OCInspections.ClangCompilerIssues.class.equals(inspectionClass.getSuperclass());
    }

    public boolean isClangAnalyzerInspection(Class inspectionClass) {
        return OCInspections.ClangAnalyzerIssue.class.equals(inspectionClass.getSuperclass());
    }

    @Nullable
    public Class getInspectionByName(String name2) {
        return this.myNameToInspectionMap.get(name2);
    }

    @Nullable
    public synchronized Class getFakeInspection(String messageGroup) {
        Class clazz = this.myNameToFakeInspectionsMap.get(messageGroup);
        if (clazz != null) {
            return clazz;
        }
        clazz = (Class)this.myFakeInspectionsPool.pop();
        if (clazz != null) {
            this.myFakeInspectionsToNameMap.put(clazz, messageGroup);
            this.myNameToFakeInspectionsMap.put(messageGroup, clazz);
            return clazz;
        }
        OCLog.LOG.error("Too few fake inspections");
        return null;
    }

    @Nullable
    public synchronized String getFakeInspectionName(Class inspectionClass) {
        return this.myFakeInspectionsToNameMap.get(inspectionClass);
    }
}

