/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import java.awt.Component;
import java.util.function.Predicate;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInspectionUtil {
    private OCInspectionUtil() {
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull Class<? extends OCInspection> inspectionClass, @Nullable PsiElement element, @NotNull HighlightSeverity defaultHighlightSeverity) {
        if (inspectionClass == OCInspections.OtherObjC.class || inspectionClass == OCInspections.OtherCpp.class || element == null) {
            return defaultHighlightSeverity;
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)inspectionClass.getSimpleName());
        if (highlightDisplayKey == null) {
            return defaultHighlightSeverity;
        }
        if (!inspectionProfile.isToolEnabled(highlightDisplayKey, element) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        HighlightDisplayLevel highlightDisplayLevel = inspectionProfile.getErrorLevel(highlightDisplayKey, element);
        return highlightDisplayLevel.getSeverity();
    }

    public static void restartCodeAnalyzer() {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isInitialized() || project2.isDisposed()) continue;
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project2).restart();
        }
    }

    @NotNull
    public static HyperlinkLabel createLinkToConfigurable(@NotNull String hyperlinkText, final @NotNull Class<? extends Configurable> targetConfigurable, final @Nullable Predicate<? super Configurable> predicate) {
        final HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(hyperlinkText);
        hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlinkLabel);
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project2 != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project2, c -> ConfigurableWrapper.cast((Class)targetConfigurable, (UnnamedConfigurable)c) != null && (predicate == null || predicate.test(c)), null);
                }
            }
        });
        return hyperlinkLabel;
    }
}

