/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.WaitFor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.clang.ClangResponseTimeoutException;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangFile;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OurClangTidyInspection
extends ClangTidyInspectionBase {
    public static final Key<Object> CLANG_ALLOW_REUSE_PARSED_FILE = Key.create((String)"ClangAllowReuseParsedFileForClangTidyInspection");
    public static final Key<Object> CLANG_DONT_CLOSE_FILE = Key.create((String)"ClangDontCloseFileAfterClangTidyInspection");
    private static final Key<ClangFile> CLANG_FILE_KEY = Key.create((String)"CLANG_FILE_KEY");
    private static final Key<Boolean> FILE_REPARSED = Key.create((String)"FILE_REPARSED");
    private static final Key<OpenRequestId> FILE_OPEN_REQUEST_ID_KEY = Key.create((String)"FILE_OPEN_REQUEST_ID_KEY");
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());

    protected OurClangTidyInspection() {
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    public abstract String getCheckName();

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        return clangTidyMessage;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName() {
        return false;
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        return this.getShortName();
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (isOnTheFly) {
            return;
        }
        if (session.getUserData(FILE_REPARSED) != Boolean.TRUE) {
            PsiFile file = session.getFile();
            VirtualFile virtualFile = file.getVirtualFile();
            ClangLanguageService languageService = ClangLanguageServiceProvider.getLanguageService(file.getProject());
            SimpleOpenRequestId openRequestId = new SimpleOpenRequestId(virtualFile.getPath() + " opened for analysis in batch mode");
            languageService.notifyDocumentOpened(virtualFile, openRequestId);
            ClangFile clangFile = languageService.getLastClangFile(virtualFile);
            if (!this.canReuse(file.getProject(), clangFile)) {
                clangFile = languageService.notifyReparseRequired(virtualFile, false);
            }
            session.putUserData(CLANG_FILE_KEY, (Object)clangFile);
            session.putUserData(FILE_OPEN_REQUEST_ID_KEY, (Object)openRequestId);
            session.putUserData(FILE_REPARSED, (Object)Boolean.TRUE);
        }
    }

    private boolean canReuse(@NotNull Project project2, @Nullable ClangFile file) {
        try {
            if (file == null || !file.getOperation().isReparseEvent()) {
                return false;
            }
            if (CLANG_ALLOW_REUSE_PARSED_FILE.get((UserDataHolder)project2) != null) {
                return true;
            }
            if (file.getOperation() == ClangFile.Operation.StrongReparse) {
                return true;
            }
            if (ClangFile.didAnswersCome(file)) {
                return file.getOurTidyDiagnostics().get() != null;
            }
            long timeoutMs = ApplicationManager.getApplication().isDispatchThread() ? 100L : 60000L;
            return ClangUtils.waitForClangFuture(file.getOurTidyDiagnostics(), timeoutMs, "Our clang-tidy diagnostics") != null;
        }
        catch (InterruptedException | ExecutionException ex) {
            this.LOG.error((Throwable)ex);
            return false;
        }
        catch (ClangResponseTimeoutException ex) {
            return false;
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, final boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        return new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                if (isOnTheFly) {
                    return;
                }
                ClangFile clangFile = (ClangFile)session.getUserData(CLANG_FILE_KEY);
                if (clangFile == null) {
                    return;
                }
                final CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> future = clangFile.getOurTidyDiagnostics();
                try {
                    List<ClangTidyDiagnostic> allDiagnostics;
                    new WaitFor(){

                        protected boolean condition() {
                            ProgressManager.checkCanceled();
                            return future.isDone();
                        }
                    };
                    if (future.isDone() && (allDiagnostics = ClangLanguageServiceUtils.getFromClangFuture(future)) != null) {
                        ProblemDescriptor[] descriptors;
                        List diagnostics = ContainerUtil.filter(allDiagnostics, diagnostic -> diagnostic.getDiagnosticName().equals(OurClangTidyInspection.this.getCheckName()));
                        AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file), true);
                        ClangTidyAnnotationApplier applier = new ClangTidyAnnotationApplier();
                        Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                        if (document2 == null) {
                            return;
                        }
                        applier.applySuccess(file, document2, diagnostics, (AnnotationHolder)annotationHolder);
                        for (ProblemDescriptor descriptor2 : descriptors = ProblemDescriptorUtil.convertToProblemDescriptors((List)annotationHolder, (PsiFile)file)) {
                            problemsHolder.registerProblem(descriptor2);
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    OurClangTidyInspection.this.LOG.warn(((Object)((Object)this)).getClass().getName() + " in batch mode failed: " + e);
                }
            }
        };
    }

    @Override
    public final JComponent createOptionsPanel() {
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        JPanel panel = new JPanel(new GridBagLayout());
        this.createOptionsPanel(panel, bag);
        OurClangTidyInspection.appendClangdHintFooter(panel, bag);
        return panel;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        OpenRequestId openRequestId = (OpenRequestId)session.getUserData(FILE_OPEN_REQUEST_ID_KEY);
        if (openRequestId != null) {
            PsiFile file = session.getFile();
            if (CLANG_DONT_CLOSE_FILE.get((UserDataHolder)session.getFile().getProject()) == null) {
                ClangLanguageServiceProvider.getLanguageService(file.getProject()).notifyDocumentClosed(file.getVirtualFile(), openRequestId);
            }
            session.putUserData(FILE_OPEN_REQUEST_ID_KEY, null);
        }
    }

    protected void createOptionsPanel(@NotNull JPanel panel, @NotNull GridBag bag) {
    }

    protected static void appendClangdHintFooter(@NotNull JPanel panel, @NotNull GridBag bag) {
        panel.add((Component)new JBLabel("Note, the inspection works only if Clangd is enabled:"), bag.nextLine().nextLine().insets((Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0)));
        panel.add((Component)OCInspection.createOpenClangdSettingsHyperlink(), bag.nextLine().weighty(1.0).insets((Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0)));
    }
}

