/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.inspections.OCSimplifyInspection;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;

public abstract class OCConvertToIfIntentionActionBase
extends PsiElementBaseIntentionAction {
    protected void invoke(OCExpression expression, OCExpression condition, OCExpression positiveExpression, OCExpression negativeExpression) {
        PsiDocumentManager mngr;
        Document document2;
        PsiElement element;
        condition = OCParenthesesUtils.diveIntoParentheses(condition);
        positiveExpression = OCParenthesesUtils.diveIntoParentheses(positiveExpression);
        negativeExpression = OCParenthesesUtils.diveIntoParentheses(negativeExpression);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{OCStatement.class, OCDeclarator.class});
        OCStatement statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, OCStatement.class, (boolean)false);
        if (expression == null || statement2 == null) {
            return;
        }
        StringBuilder builder = new StringBuilder("if (");
        OCExpression conditionalExprWithParens = OCParenthesesUtils.topmostParenthesized(expression);
        if (condition != null) {
            builder.append(condition.getTextWithMacros());
        }
        builder.append(") {\n");
        if (parent instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)parent;
            OCExpression initializer = declarator.getInitializer();
            builder.append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder, initializer, conditionalExprWithParens, positiveExpression);
            builder.append(";\n}\nelse {\n").append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder, initializer, conditionalExprWithParens, negativeExpression);
            builder.append(";\n}");
            OCChangeUtil.delete(initializer);
        } else {
            OCConvertToIfIntentionActionBase.appendElementText(builder, statement2, conditionalExprWithParens, positiveExpression);
            builder.append("}\nelse {\n");
            OCConvertToIfIntentionActionBase.appendElementText(builder, statement2, conditionalExprWithParens, negativeExpression);
            builder.append("\n}");
        }
        OCIfStatement ifStatement = (OCIfStatement)OCElementFactory.statementFromText(builder.toString(), expression, true);
        PsiElement psiElement = element = parent instanceof OCDeclarator ? OCChangeUtil.addAfter(statement2.getParent(), ifStatement, statement2) : OCChangeUtil.replaceHandlingMacros(statement2, ifStatement);
        if (element instanceof OCIfStatement && (document2 = (mngr = PsiDocumentManager.getInstance((Project)element.getProject())).getDocument(element.getContainingFile())) != null) {
            mngr.doPostponedOperationsAndUnblockDocument(document2);
            OCSimplifyInspection.simplify(((OCIfStatement)element).getThenBranch());
            OCSimplifyInspection.simplify(((OCIfStatement)element).getElseBranch());
        }
    }

    private static void appendElementText(StringBuilder builder, PsiElement element, OCExpression elementToReplace, OCExpression replacement) {
        if (element == elementToReplace) {
            if (OCParenthesesUtils.isParenthesesNeededInReplacing(elementToReplace, replacement)) {
                builder.append('(').append(OCElementUtil.getTextWithMacros(replacement)).append(')');
            } else {
                builder.append(OCElementUtil.getTextWithMacros(replacement));
            }
        } else {
            List<PsiElement> children = OCElementUtil.getAllChildren(element);
            if (children.size() > 0) {
                for (PsiElement child : children) {
                    OCConvertToIfIntentionActionBase.appendElementText(builder, child, elementToReplace, replacement);
                }
            } else if (!OCElementUtil.isPartOfMacroSubstitution(element)) {
                builder.append(OCElementUtil.getTextWithMacros(element));
            }
        }
    }
}

