/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.TextRangeUtil;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.inspections.OCSimplifyInspection;
import com.jetbrains.cidr.lang.intentions.OCDeMorganIntentionAction;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCControlFlowUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInvertIfConditionIntentionAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.intentions.OCInvertIfConditionIntentionAction");

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Invert 'if' condition";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        IElementType elementType;
        OCIfStatement ifStatement = (OCIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCIfStatement.class, (boolean)false);
        if (ifStatement == null) {
            return false;
        }
        if (ifStatement.getCondition() == null || ifStatement.getThenBranch() == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (!ifStatement.getCondition().getTextRange().contains(offset) && (elementType = element.getNode().getElementType()) != OCTokenTypes.IF_KEYWORD && elementType != OCTokenTypes.ELSE_KEYWORD) {
            return false;
        }
        return OCInvertIfConditionIntentionAction.canInvertCondition(ifStatement.getCondition()) && OCInvertIfConditionIntentionAction.canBuildControlFlow(ifStatement);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCIfStatement ifStatement = (OCIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCIfStatement.class);
        LOG.assertTrue(ifStatement != null);
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCCallable.class);
        LOG.assertTrue(callable != null);
        OCControlFlowGraph controlFlowGraph = OCControlFlowUtil.buildControlFlowGraph(callable);
        OCNode ifNode = OCControlFlowUtil.findNodeForElement(controlFlowGraph, ifStatement);
        LOG.assertTrue(ifNode != null);
        List<OCNode> jumpTargets = ifNode.getJumpTargets();
        LOG.assertTrue(jumpTargets != null && jumpTargets.size() == 2);
        OCNode thenNode = jumpTargets.get(0);
        OCNode elseNode = OCControlFlowUtil.getSignificantNode(jumpTargets.get(1));
        OCInvertIfConditionIntentionAction.invertCondition(project2, editor, ifStatement);
        ifStatement = OCInvertIfConditionIntentionAction.invertBranches(callable, ifStatement, thenNode, elseNode);
        OCInvertIfConditionIntentionAction.reformat(project2, editor.getDocument(), ifStatement);
    }

    private static OCIfStatement invertBranches(@NotNull OCCallable callable, @NotNull OCIfStatement ifStatement, @NotNull OCNode thenNode, @NotNull OCNode elseNode) {
        boolean hasElseBranch;
        OCCondition condition = ifStatement.getCondition();
        LOG.assertTrue(condition != null);
        OCStatement thenBranch = ifStatement.getThenBranch();
        LOG.assertTrue(thenBranch != null);
        OCStatement elseBranch = ifStatement.getElseBranch();
        boolean bl = hasElseBranch = elseBranch != null;
        if (hasElseBranch) {
            OCStatement elseBranchCopy = (OCStatement)OCChangeUtil.copyHandlingMacros(elseBranch);
            ifStatement.setElse(OCInvertIfConditionIntentionAction.surroundByBracesOptional(thenBranch));
            ifStatement.setThen(OCInvertIfConditionIntentionAction.surroundByBracesOptional(elseBranchCopy));
            return ifStatement;
        }
        PsiElement elementToJump = OCControlFlowUtil.getFirstPsiElement(elseNode);
        if (elementToJump == null) {
            OCResolveContext resolveContext = OCResolveContext.forPsi(callable);
            if (OCCallableUtil.hasVoidReturnType(callable, resolveContext)) {
                OCInvertIfConditionIntentionAction.renameNestedDeclaratorsWithCollisions(ifStatement, callable);
                ifStatement = (OCIfStatement)OCChangeUtil.addAfterWithinBlockStatement(thenBranch, ifStatement);
                ifStatement.setThen(OCElementFactory.statementFromText("return;", ifStatement));
                OCInvertIfConditionIntentionAction.optimizeRedundantStatements(ifStatement, null, callable);
                return ifStatement;
            }
        } else {
            if (OCInvertIfConditionIntentionAction.backwardJumpToLoop(elementToJump, ifStatement)) {
                OCInvertIfConditionIntentionAction.renameNestedDeclaratorsWithCollisions(ifStatement, callable);
                ifStatement = (OCIfStatement)OCChangeUtil.addAfterWithinBlockStatement(thenBranch, ifStatement);
                ifStatement.setThen(OCElementFactory.statementFromText("continue;", ifStatement));
                OCInvertIfConditionIntentionAction.optimizeRedundantStatements(ifStatement, null, callable);
                return ifStatement;
            }
            if (OCInvertIfConditionIntentionAction.isControlFlowStatement(elementToJump)) {
                OCInvertIfConditionIntentionAction.renameNestedDeclaratorsWithCollisions(ifStatement, callable);
                ifStatement = (OCIfStatement)OCChangeUtil.addAfterWithinBlockStatement(thenBranch, ifStatement);
                ifStatement.setThen((OCStatement)OCChangeUtil.copyHandlingMacros(elementToJump));
                OCInvertIfConditionIntentionAction.optimizeRedundantStatements(ifStatement, elementToJump, callable);
                return ifStatement;
            }
            if (!OCControlFlowUtil.isNodeReachableFrom(thenNode, elseNode, false)) {
                PsiElement firstSibling;
                PsiElement psiElement = firstSibling = ifStatement.getParent() instanceof OCCaseStatement ? OCElementUtil.getNextSiblingOrParentSibling(ifStatement) : ifStatement.getNextSibling();
                if (firstSibling != null) {
                    PsiElement lastSibling = firstSibling;
                    for (PsiElement nextSibling = lastSibling.getNextSibling(); nextSibling != null && nextSibling.getNode().getElementType() != OCTokenTypes.RBRACE && !(nextSibling instanceof OCCaseStatement); nextSibling = nextSibling.getNextSibling()) {
                        lastSibling = nextSibling;
                    }
                    OCBlockStatement blockStatement = (OCBlockStatement)OCElementFactory.statementFromText("{}", ifStatement);
                    blockStatement.addRangeAfter(firstSibling, lastSibling, blockStatement.getOpeningBrace());
                    firstSibling.getParent().deleteChildRange(firstSibling, lastSibling);
                    ifStatement.setElse(OCInvertIfConditionIntentionAction.surroundByBracesOptional(thenBranch));
                    ifStatement.setThen(blockStatement);
                    OCInvertIfConditionIntentionAction.optimizeElseBranch(ifStatement);
                    return ifStatement;
                }
            }
        }
        ifStatement.setElse(OCInvertIfConditionIntentionAction.surroundByBracesOptional(thenBranch));
        ifStatement.setThen(OCElementFactory.statementFromText("{}", ifStatement));
        return ifStatement;
    }

    private static OCStatement surroundByBracesOptional(@NotNull OCStatement element) {
        if (element instanceof OCExpressionStatement || OCInvertIfConditionIntentionAction.isControlFlowStatement(element)) {
            return element;
        }
        return OCElementFactory.surroundByBraces(element);
    }

    private static void renameNestedDeclaratorsWithCollisions(@NotNull OCIfStatement ifStatement, @NotNull OCCallable callable) {
        Set<PsiNamedElement> nestedDeclarators = OCCodeInsightUtil.collectDeclarators(ifStatement);
        Set<PsiNamedElement> declarators = OCCodeInsightUtil.collectDeclarators(callable);
        declarators.removeAll(nestedDeclarators);
        Set declaratorNames = declarators.stream().map(declarator -> declarator.getName()).collect(Collectors.toSet());
        for (PsiNamedElement nestedDeclarator : nestedDeclarators) {
            if (!declaratorNames.contains(nestedDeclarator.getName())) continue;
            OCSymbol nestedDeclaratorSymbol = ((OCDeclarator)nestedDeclarator).getSymbol();
            List<PsiElement> nestedDeclaratorUsages = OCCodeInsightUtil.getReferences(nestedDeclarator);
            String newNestedDeclaratorName = OCNameSuggester.suggestUniqueName(nestedDeclaratorSymbol, ifStatement, callable.getProject());
            OCCodeInsightUtil.renameDeclaratorAndUsages(nestedDeclarator, newNestedDeclaratorName, nestedDeclaratorUsages);
        }
    }

    private static boolean isControlFlowStatement(@NotNull PsiElement element) {
        if (element instanceof OCExpressionStatement) {
            OCExpression expression = ((OCExpressionStatement)element).getExpression();
            return expression instanceof OCThrowExpression;
        }
        return element instanceof OCReturnStatement || element instanceof OCContinueStatement || element instanceof OCBreakStatement || element instanceof OCGotoStatement;
    }

    private static boolean backwardJumpToLoop(@NotNull PsiElement elementToJump, @NotNull OCIfStatement ifStatement) {
        OCLoopStatement loopStatement;
        if (elementToJump instanceof OCLoopStatement) {
            loopStatement = (OCLoopStatement)elementToJump;
        } else {
            loopStatement = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)elementToJump, OCLoopStatement.class);
            if (loopStatement == null) {
                return false;
            }
            ASTNode leftParenth = loopStatement.getLParenth();
            ASTNode rightParenth = loopStatement.getRParenth();
            if (leftParenth == null || rightParenth == null) {
                return false;
            }
            TextRange loopConditionTextRange = TextRangeUtil.getEnclosingTextRange(Arrays.asList(leftParenth.getTextRange(), rightParenth.getTextRange()));
            if (!loopConditionTextRange.contains(elementToJump.getTextOffset())) {
                return false;
            }
        }
        return PsiTreeUtil.isAncestor((PsiElement)loopStatement, (PsiElement)ifStatement, (boolean)true);
    }

    private static void reformat(@NotNull Project project2, @NotNull Document document2, @NotNull OCIfStatement ifStatement) {
        RangeMarker adjustRange = null;
        if (ifStatement.getElseBranch() != null) {
            adjustRange = document2.createRangeMarker(ifStatement.getTextRange().getStartOffset(), ifStatement.getParent().getTextRange().getEndOffset());
        }
        RangeMarker formatRange = document2.createRangeMarker(ifStatement.getTextRange().getStartOffset(), ifStatement.getTextRange().getEndOffset());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        OCFile file = ifStatement.getContainingOCFile();
        OCChangeUtil.processPostponedFormatIfNeed(file);
        if (formatRange.isValid()) {
            codeStyleManager.reformatText((PsiFile)file, formatRange.getStartOffset(), formatRange.getEndOffset());
            if (adjustRange != null && adjustRange.isValid()) {
                codeStyleManager.adjustLineIndent((PsiFile)file, TextRange.create((Segment)adjustRange));
            }
        }
    }

    private static void invertCondition(@NotNull Project project2, @NotNull Editor editor, @NotNull OCIfStatement ifStatement) {
        OCCondition condition = ifStatement.getCondition();
        LOG.assertTrue(condition != null && condition.getExpression() != null);
        OCExpression conditionExpression = condition.getExpression();
        OCExpression expressionToInvert = OCParenthesesUtils.getPrecedence(conditionExpression, false) > 3 ? OCParenthesesUtils.appendParentheses(conditionExpression) : conditionExpression;
        ifStatement.setCondition(OCElementFactory.unaryExpression(expressionToInvert, OCTokenTypes.EXCL));
        OCSimplifyInspection.simplify(ifStatement.getCondition());
        if (!(ifStatement.getCondition().getExpression() instanceof OCUnaryExpression)) {
            return;
        }
        OCExpression operand = OCParenthesesUtils.diveIntoParentheses(((OCUnaryExpression)ifStatement.getCondition().getExpression()).getOperand());
        OCDeMorganIntentionAction deMorganIntentionAction = new OCDeMorganIntentionAction();
        if (operand != null && deMorganIntentionAction.isAvailable(project2, editor, operand)) {
            deMorganIntentionAction.invoke(project2, editor, operand);
        }
    }

    private static boolean canInvertCondition(@NotNull OCCondition condition) {
        return condition.getDeclaration() == null && condition.getExpression() != null;
    }

    private static void optimizeRedundantStatements(@NotNull OCIfStatement ifStatement, @Nullable PsiElement elementToJump, @NotNull OCCallable callable) {
        OCStatement lastStatement;
        List<OCStatement> statements;
        OCLoopStatement loopStatement;
        OCControlFlowGraph controlFlowGraph;
        if (elementToJump != null && OCControlFlowUtil.isUnreachable(controlFlowGraph = OCInvertIfConditionIntentionAction.buildLocalControlFlowGraph(elementToJump, callable), elementToJump)) {
            OCChangeUtil.delete(elementToJump);
        }
        if ((loopStatement = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCLoopStatement.class)) != null && loopStatement.getBody() instanceof OCBlockStatement && !(statements = ((OCBlockStatement)loopStatement.getBody()).getStatements()).isEmpty()) {
            lastStatement = statements.get(statements.size() - 1);
            if (statements.contains(ifStatement) && lastStatement instanceof OCContinueStatement) {
                OCChangeUtil.delete(lastStatement);
            }
        }
        if (callable.getBody() != null && !(statements = callable.getBody().getStatements()).isEmpty()) {
            lastStatement = statements.get(statements.size() - 1);
            if (statements.contains(ifStatement) && OCInvertIfConditionIntentionAction.isEmptyReturn(lastStatement)) {
                OCChangeUtil.delete(lastStatement);
            }
        }
    }

    private static void optimizeElseBranch(@NotNull OCIfStatement ifStatement) {
        List<OCStatement> elseStatements;
        OCStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch == null || !OCInvertIfConditionIntentionAction.isLastStatement(ifStatement)) {
            return;
        }
        List<OCStatement> list = elseStatements = elseBranch instanceof OCBlockStatement ? ((OCBlockStatement)elseBranch).getStatements() : Collections.singletonList(elseBranch);
        if (elseStatements.isEmpty()) {
            return;
        }
        OCStatement lastElseStatement = elseStatements.get(elseStatements.size() - 1);
        boolean canOptimize = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCLoopStatement.class) != null) {
            if (lastElseStatement instanceof OCContinueStatement) {
                canOptimize = true;
            }
        } else if (OCInvertIfConditionIntentionAction.isEmptyReturn(lastElseStatement)) {
            canOptimize = true;
        }
        if (!canOptimize) {
            return;
        }
        if (elseStatements.size() == 1) {
            ASTNode ifStatementNode = ifStatement.getNode();
            ifStatementNode.removeRange(ifStatement.getElseKeyword(), elseBranch.getNode().getTreeNext());
        } else {
            OCChangeUtil.delete(lastElseStatement);
        }
    }

    private static boolean isEmptyReturn(@NotNull PsiElement element) {
        return element instanceof OCReturnStatement && ((OCReturnStatement)element).getExpression() == null;
    }

    private static boolean isLastStatement(@NotNull OCStatement statement2) {
        PsiElement parentStatement = statement2.getParent();
        while (!(parentStatement instanceof OCLoopStatement) && !(parentStatement instanceof OCCallable)) {
            List<OCStatement> statements;
            if (parentStatement instanceof OCBlockStatement && !(statements = ((OCBlockStatement)parentStatement).getStatements()).isEmpty() && !PsiTreeUtil.isAncestor((PsiElement)statements.get(statements.size() - 1), (PsiElement)statement2, (boolean)false)) {
                return false;
            }
            parentStatement = parentStatement.getParent();
        }
        return true;
    }

    private static boolean canBuildControlFlow(@NotNull OCIfStatement ifStatement) {
        return PsiTreeUtil.getParentOfType((PsiElement)ifStatement, OCCallable.class) != null;
    }

    @NotNull
    private static OCControlFlowGraph buildLocalControlFlowGraph(@NotNull PsiElement element, @NotNull OCCallable callable) {
        PsiElement scopeElement = PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class);
        if (scopeElement == null) {
            scopeElement = callable;
        }
        return OCControlFlowUtil.buildControlFlowGraph(scopeElement, callable);
    }
}

