/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveIvarsToImplementationIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Move instance variables to implementation";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair2 = this.locateCandidate(editor, file);
        return OCCompilerFeatures.supportsIvarsInImplementation() && pair2 != null && OCCodeInsightUtil.isValid((PsiElement)pair2.getFirst()) && OCCodeInsightUtil.isValid((PsiElement)pair2.getSecond()) && !((OCInstanceVariablesList)pair2.getFirst()).isEmpty() && ((OCInstanceVariablesList)pair2.getSecond()).isEmpty();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Pair<OCInstanceVariablesList, OCInstanceVariablesList> pair2 = this.locateCandidate(editor, file);
        if (pair2 != null) {
            PsiFile srcFile = ((OCInstanceVariablesList)pair2.getFirst()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(srcFile)) {
                return;
            }
            PsiFile dstFile = ((OCInstanceVariablesList)pair2.getSecond()).getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(dstFile)) {
                return;
            }
            OCChangeUtil.changeText(project2, dstFile, ((OCInstanceVariablesList)pair2.getSecond()).getTextOffset(), 0, ((OCInstanceVariablesList)pair2.getFirst()).getTextWithMacros(), true);
            OCChangeUtil.changeText(project2, srcFile, ((OCInstanceVariablesList)pair2.getFirst()).getTextOffset(), ((OCInstanceVariablesList)pair2.getFirst()).getTextLength(), "", true);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    protected Pair<OCInstanceVariablesList, OCInstanceVariablesList> locateCandidate(Editor editor, PsiFile file) {
        PsiElement implementation;
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCInstanceVariablesList intfList = OCElementUtil.getAdjacentParentOfType(at, OCInstanceVariablesList.class);
        OCInterface anInterface = (OCInterface)PsiTreeUtil.getParentOfType((PsiElement)intfList, OCInterface.class);
        if (anInterface == null) {
            return null;
        }
        OCInterfaceSymbol interfaceSymbol = anInterface.getSymbol();
        Project project2 = file.getProject();
        OCImplementationSymbol implementationSymbol = interfaceSymbol != null ? interfaceSymbol.getImplementation(project2) : null;
        PsiElement psiElement = implementation = implementationSymbol != null ? implementationSymbol.locateDefinition(project2) : null;
        if (implementation instanceof OCClassDeclaration) {
            return Pair.create((Object)intfList, (Object)((OCClassDeclaration)implementation).getInstanceVariablesList());
        }
        return null;
    }
}

