/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSynthesizePropertyIntentionAction
extends OCGenerateIvarsHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Synthesize property";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    protected OCPropertySymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file) {
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator parent = OCElementUtil.getAdjacentParentOfType(at, OCDeclarator.class);
        if (parent != null) {
            OCSymbol symbol = parent.getSymbol();
            return symbol instanceof OCPropertySymbol && OCGenerateIvarsHandler.isPropertyDefective((OCPropertySymbol)symbol, project2) ? (OCPropertySymbol)symbol : null;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (!FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            return false;
        }
        return OCCompilerFeatures.supportsAutosynthesis(file) && OCSearchScope.isInProjectSources(this.locateCandidate(project2, editor, file), project2);
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        OCPropertySymbol prop = this.locateCandidate(project2, editor, file);
        return prop != null ? prop.getParent().getMainInterface(project2) : null;
    }

    @Override
    protected boolean replaceAllProperties() {
        return false;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }
}

