/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCAddSuperConstructorCallsFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final Collection<OCStructSymbol> myClassesMissingBaseCtors;

    public OCAddSuperConstructorCallsFix(@NotNull OCFunctionSymbol constructor, Collection<OCStructSymbol> classesMissingBaseCtors, @NotNull Project project2) {
        super(project2, constructor);
        this.myClassesMissingBaseCtors = classesMissingBaseCtors;
    }

    @Override
    protected String getTextInternal() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return "Add missing base constructor calls";
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        OCFunctionDefinition constructor = (OCFunctionDefinition)((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project2);
        if (constructor == null) {
            return;
        }
        ArrayList<Collection<OCFunctionSymbol>> baseConstructors = new ArrayList<Collection<OCFunctionSymbol>>();
        for (OCStructSymbol baseClass : this.myClassesMissingBaseCtors) {
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            baseClass.processConstructors((Processor<? super OCFunctionSymbol>)collector, OCResolveContext.forPsi(constructor));
            if (collector.getResults().isEmpty()) continue;
            baseConstructors.add(collector.getResults());
        }
        List<OCFunctionSymbol> chosenCtors = OCGenerateConstructorHandler.chooseBaseConstructors(baseConstructors, project2);
        if (chosenCtors == null) {
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(constructor, constructor, true);
        HashSet<String> names = new HashSet<String>(ContainerUtil.map(((OCFunctionSymbol)this.mySymbol).getParameterSymbols(), symbol1 -> symbol1.getName()));
        int index = 0;
        OCConstructorInitializationList list = OCElementFactory.constructorInitializationList(constructor);
        for (OCFunctionSymbol baseConstructor : chosenCtors) {
            StringBuilder builder = new StringBuilder();
            builder.append(baseConstructor.getName()).append("(");
            boolean firstParam = true;
            for (OCDeclaratorSymbol param : baseConstructor.getParameterSymbols()) {
                String name2 = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, param.getName(), null, names, project2);
                names.add(name2);
                handler.insertParameter(name2, param.getType(), index++);
                if (!firstParam) {
                    builder.append(",");
                }
                firstParam = false;
                builder.append(name2);
            }
            builder.append(")");
            OCChangeUtil.add(list, OCElementFactory.constructorFieldInitializerFromText(builder.toString(), constructor));
        }
        OCConstructorInitializationList existingList = constructor.getConstructorInitializationList();
        if (existingList != null) {
            for (OCConstructorFieldInitializer initializer : existingList.getInitializers()) {
                OCChangeUtil.add(list, initializer);
            }
        }
        handler.getGeneratedInfo().runOnSuccess(() -> constructor.setConstructorInitializationList(list));
        handler.setTitle(this.getText());
        handler.invoke();
    }
}

