/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCMoveDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCVisibility {
    public static boolean checkFieldVisibility(OCSymbol field, @NotNull PsiElement element, @Nullable OCType qualifierType, @NotNull OCAnnotatorSink sink) {
        String subjectName;
        if (!(field instanceof OCSymbolWithQualifiedName) && !(field instanceof OCInstanceVariableSymbol)) {
            return true;
        }
        if (element.getParent() instanceof OCStruct && !((OCStruct)element.getParent()).isDeclaration()) {
            return true;
        }
        Project project2 = element.getProject();
        OCSymbolWithParent symbol = (OCSymbolWithParent)field;
        com.jetbrains.cidr.lang.symbols.OCVisibility declaredVisibility = com.jetbrains.cidr.lang.symbols.OCVisibility.getDeclaredVisibility(symbol, project2);
        OCResolveContext context = OCResolveContext.forPsi(element);
        String string = subjectName = symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames(true, false, context) : symbol.getNameWithParent(context);
        if (field instanceof OCFunctionSymbol && ((OCFunctionSymbol)field).isDelete()) {
            Annotation annotation = sink.addErrorAnnotation(element, OCInspections.MemberVisibility.class, "err_ovl_deleted_member_call", "'" + subjectName + "' is deleted");
            PsiElement funElement = symbol.locateDefinition(project2);
            if (funElement instanceof OCDeclarator) {
                ASTNode deleteKeyword2 = (ASTNode)ContainerUtil.find((Object[])funElement.getNode().getChildren(null), node -> node.getElementType() == OCTokenTypes.DELETE_CPP_KEYWORD);
                if (deleteKeyword2 != null) {
                    sink.registerQuickFix(annotation, new OCChangeTextIntentionAction(deleteKeyword2.getPsi().getContainingFile(), deleteKeyword2.getStartOffset(), deleteKeyword2.getTextLength(), "default", "Make " + field.getNameWithKindLowercase(context) + " default"));
                }
                sink.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol, project2));
            }
            return false;
        }
        if (declaredVisibility == null) {
            return true;
        }
        com.jetbrains.cidr.lang.symbols.OCVisibility visibility = com.jetbrains.cidr.lang.symbols.OCVisibility.getMinimalVisibilityForSymbolToBeAccessible(symbol, element, qualifierType);
        if (visibility.ordinal() >= declaredVisibility.ordinal()) {
            return true;
        }
        Annotation annotation = sink.addErrorAnnotation(element, OCInspections.MemberVisibility.class, "err_access", (Object)((Object)declaredVisibility) + " '" + subjectName + "' is inaccessible");
        if (visibility.ordinal() >= com.jetbrains.cidr.lang.symbols.OCVisibility.PUBLIC.ordinal()) {
            sink.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, com.jetbrains.cidr.lang.symbols.OCVisibility.PUBLIC, context));
        }
        if (symbol instanceof OCInstanceVariableSymbol) {
            sink.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, com.jetbrains.cidr.lang.symbols.OCVisibility.PACKAGE, context));
        }
        if (visibility.ordinal() >= com.jetbrains.cidr.lang.symbols.OCVisibility.PROTECTED.ordinal()) {
            sink.registerQuickFix(annotation, new OCChangeVisibilityIntentionAction(symbol, com.jetbrains.cidr.lang.symbols.OCVisibility.PROTECTED, context));
            if (symbol instanceof OCInstanceVariableSymbol) {
                OCInterfaceSymbol intfSymbol;
                OCImplementation clazz = (OCImplementation)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCImplementation.class});
                OCImplementationSymbol implSymbol = clazz.getSymbol();
                OCInterfaceSymbol oCInterfaceSymbol = intfSymbol = implSymbol != null ? implSymbol.getInterface(project2) : null;
                if (implSymbol != null) {
                    sink.registerQuickFix(annotation, new OCMoveDefinitionIntentionAction(symbol.getKind(), element, intfSymbol, symbol));
                }
            }
        }
        return false;
    }
}

