/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCIntType
extends OCTypeCompatibilityVisitor<OCIntType> {
    protected OCTypeCompatibilityVisitor_OCIntType(@NotNull OCIntType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(OCFunctionType type) {
        String message = "Taking pointer from integer without a cast";
        return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(OCPointerType type) {
        OCTypeCheckResult result;
        OCType lTerminalType = type.getTerminalType();
        if (((OCIntType)this.mySourceType).isPointerCompatible(this.myResolveContext, false) && !lTerminalType.isUnknown() && type.isPointerToPointerToObjectCompatible() ^ ((OCIntType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerFeatures.isArcEnabled(this.myContext.getContainingFile()) && (result = this.checkArcBridgeCast(type, false)) != null) {
            return result;
        }
        return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP, "Taking pointer from integer without a cast", OCInspections.ImplicitPointerAndIntegerConversion.class, "ext_typecheck_convert_int_pointer", new IntentionAction[0]);
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        if (type.getKind() == OCSymbolKind.ENUM) {
            Computable message;
            if (type.isUnnamed() && type.getTypedefName() == null) {
                if (!type.isEnumClass()) {
                    return OCTypeCheckResultBuilder.createOK();
                }
                message = () -> "Taking enum class type '" + type.getBestNameInContext(this.myResolveContext) + "' from integer";
            } else {
                message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from integer";
            }
            return this.checkAssignToEnum(type, (Computable<String>)message);
        }
        return this.checkStructCompatibleCtor(type);
    }
}

