/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.types.visitors;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.legacy.types.OCTypeCheckResultBuilder;
import com.jetbrains.cidr.lang.legacy.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCSetSuperclassIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCObjectType
extends OCTypeCompatibilityVisitor<OCObjectType> {
    protected OCTypeCompatibilityVisitor_OCObjectType(@NotNull OCObjectType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(OCFunctionType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitObjectType(final OCObjectType type) {
        boolean compatibleClass = type.isAncestorOf((OCObjectType)this.mySourceType) || ((OCObjectType)this.mySourceType).isKindof() && ((OCObjectType)this.mySourceType).isAncestorOf(type);
        OCInterfaceSymbol anInterface = ((OCObjectType)this.mySourceType).getInterface();
        OCInterfaceSymbol typeInterface = type.getInterface();
        if (!compatibleClass && anInterface != null && typeInterface != null) {
            return new OCTypeCheckResult(OCTypeCheckState.WARNING, OCInspections.NotSuperclass.class, "CIDR", new IntentionAction[]{new OCSetSuperclassIntentionAction(anInterface, typeInterface, null, this.myResolveContext)}){

                @Override
                public String getMessage() {
                    return "Interface '" + OCTypeCompatibilityVisitor_OCObjectType.this.getSourceTypeName() + "' is not a successor of '" + type.getName(OCTypeCompatibilityVisitor_OCObjectType.this.myResolveContext) + "'";
                }
            };
        }
        if (!((OCObjectType)this.mySourceType).isKindof()) {
            return this.getProtocolCompatibilityCheckResult((OCObjectType)this.mySourceType, type);
        }
        return OCTypeCheckResultBuilder.createOK();
    }

    @Override
    public OCTypeCheckResult visitPointerType(OCPointerType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        return this.checkStructCompatibleCtor(type);
    }
}

