/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.symbols;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapDiskCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapFileSymbolPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSerializer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableSerializationVersion;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J*\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019J$\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u001cH\u0002JD\u0010\u001d\u001a\u00020\b\"\u0004\b\u0000\u0010\u001e\"\u0004\b\u0001\u0010\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u001f0!H\u0002J\u0018\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ*\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010'\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0)R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006+"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapDiskCache;", "", "()V", "mySerializers", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSerializer;", "[Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSerializer;", "cache", "", "serializer", "root", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "moduleMap", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapFileSymbolPack;", "calculateHashCode", "", "deserializeModuleMap", "inputStream", "Ljava/io/InputStream;", "deserializeModuleMaps", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "roots", "", "processor", "Lcom/intellij/util/Consumer;", "executeParallel", "consumer", "Lkotlin/Function1;", "executeParallelWithProgress", "T", "R", "items", "Lkotlin/Function2;", "getAllModuleMaps", "serializeModuleMap", "", "outputStream", "Ljava/io/OutputStream;", "serializeModuleMaps", "packs", "", "Companion", "intellij.c"})
public final class ModuleMapDiskCache {
    private final ModuleMapSerializer[] mySerializers;
    private static final String TABLES_KEY_PREFIX = "clang_module_map_attribute";
    private static final int PARALLEL_SERIALIZERS;
    private static final FileAttribute ourFileCacheAttribute;
    public static final Companion Companion;

    public final void serializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull List<ModuleMapFileSymbolPack> packs) {
        this.executeParallelWithProgress(indicator, (Collection)packs, (Function2)new Function2<ModuleMapFileSymbolPack, ModuleMapSerializer, Unit>(this){
            final /* synthetic */ ModuleMapDiskCache this$0;

            public final void invoke(@NotNull ModuleMapFileSymbolPack pack, @NotNull ModuleMapSerializer serializer2) {
                this.this$0.cache(serializer2, pack.getHeaderRoot(), pack);
            }
            {
                this.this$0 = moduleMapDiskCache;
                super(2);
            }
        });
    }

    public final void deserializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull Collection<? extends HeadersSearchRoot> roots, @NotNull Consumer<ModuleMapFileSymbolPack> processor2) {
        this.executeParallelWithProgress(indicator, roots, (Function2)new Function2<HeadersSearchRoot, ModuleMapSerializer, Unit>(this, processor2){
            final /* synthetic */ ModuleMapDiskCache this$0;
            final /* synthetic */ Consumer $processor;

            @Nullable
            public final Unit invoke(@NotNull HeadersSearchRoot root, @NotNull ModuleMapSerializer serializer2) {
                Unit unit;
                ModuleMapFileSymbolPack moduleMapFileSymbolPack = this.this$0.getAllModuleMaps(serializer2, root);
                if (moduleMapFileSymbolPack != null) {
                    ModuleMapFileSymbolPack moduleMapFileSymbolPack2;
                    ModuleMapFileSymbolPack it = moduleMapFileSymbolPack2 = moduleMapFileSymbolPack;
                    boolean bl = false;
                    this.$processor.consume((Object)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.this$0 = moduleMapDiskCache;
                this.$processor = consumer;
                super(2);
            }
        });
    }

    private final <T, R> void executeParallelWithProgress(ProgressIndicator indicator, Collection<? extends T> items, Function2<? super T, ? super ModuleMapSerializer, ? extends R> processor2) {
        ArrayDeque<? extends T> itemsQueue = new ArrayDeque<T>(items);
        int total = items.size();
        AtomicInteger counter = new AtomicInteger(0);
        indicator.setFraction(0.0);
        this.executeParallel(indicator, (Function1<? super ModuleMapSerializer, Unit>)((Function1)new Function1<ModuleMapSerializer, Unit>(itemsQueue, indicator, processor2, counter, total){
            final /* synthetic */ ArrayDeque $itemsQueue;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Function2 $processor;
            final /* synthetic */ AtomicInteger $counter;
            final /* synthetic */ int $total;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ModuleMapSerializer it) {
                Object currentItem = null;
                while (true) {
                    Object item;
                    if (currentItem == null) {
                        E e;
                        ArrayDeque arrayDeque = this.$itemsQueue;
                        synchronized (arrayDeque) {
                            boolean bl = false;
                            if (this.$itemsQueue.isEmpty()) {
                                return;
                            }
                            e = this.$itemsQueue.pop();
                        }
                        currentItem = e;
                    }
                    if (currentItem == null) {
                        Intrinsics.throwNpe();
                    }
                    currentItem = null;
                    try {
                        OCSymbolTablesBuildingActivity.runCancelableReadAction(this.$indicator, new Runnable(this, item, it){
                            final /* synthetic */ executeParallelWithProgress.1 this$0;
                            final /* synthetic */ Object $item;
                            final /* synthetic */ ModuleMapSerializer $it;

                            public final void run() {
                                this.this$0.$processor.invoke(this.$item, (Object)this.$it);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$item = object;
                                this.$it = moduleMapSerializer;
                            }
                        });
                        this.$indicator.setFraction((double)this.$counter.incrementAndGet() / (double)this.$total);
                        continue;
                    }
                    catch (ProcessCanceledException e) {
                        if (this.$indicator.isCanceled()) {
                            throw (Throwable)e;
                        }
                        currentItem = item;
                        continue;
                    }
                    break;
                }
            }
            {
                this.$itemsQueue = arrayDeque;
                this.$indicator = progressIndicator;
                this.$processor = function2;
                this.$counter = atomicInteger;
                this.$total = n;
                super(1);
            }
        }));
        indicator.setFraction(1.0);
    }

    /*
     * WARNING - void declaration
     */
    private final void executeParallel(ProgressIndicator indicator, Function1<? super ModuleMapSerializer, Unit> consumer) {
        void $receiver$iv$iv;
        ModuleMapSerializer[] $receiver$iv;
        ModuleMapSerializer[] moduleMapSerializerArray = $receiver$iv = this.mySerializers;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var7_6 = $receiver$iv$iv;
        int n = ((void)var7_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = var7_6[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Future future = ApplicationManager.getApplication().executeOnPooledThread(new Runnable((ModuleMapSerializer)it, consumer){
                final /* synthetic */ ModuleMapSerializer $it;
                final /* synthetic */ Function1 $consumer$inlined;
                {
                    this.$it = moduleMapSerializer;
                    this.$consumer$inlined = function1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        this.$consumer$inlined.invoke((Object)this.$it);
                    }
                    finally {
                        this.$it.compact();
                    }
                }
            });
            collection.add(future);
        }
        List futures = (List)destination$iv$iv;
        SmartList exceptions = new SmartList();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                exceptions.add((Object)e.getCause());
            }
        }
        if (!exceptions.isEmpty()) {
            throw (Throwable)new CompoundRuntimeException((List)exceptions);
        }
        indicator.checkCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cache(@NotNull ModuleMapSerializer serializer2, @NotNull HeadersSearchRoot root, @Nullable ModuleMapFileSymbolPack moduleMap) {
        VirtualFile virtualFile;
        Object object = root;
        if (object instanceof IncludedHeadersRoot) {
            virtualFile = ((IncludedHeadersRoot)root).getVirtualFile();
        } else if (object instanceof RealFramework) {
            virtualFile = ((RealFramework)root).getVirtualFile();
        } else {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!virtualFile2.isValid()) {
            return;
        }
        object = ourFileCacheAttribute.writeAttribute(virtualFile2);
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)object;
            boolean bl = false;
            boolean bl2 = this.serializeModuleMap(serializer2, root, it, moduleMap);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ModuleMapFileSymbolPack getAllModuleMaps(@NotNull ModuleMapSerializer serializer2, @NotNull HeadersSearchRoot root) {
        VirtualFile virtualFile;
        Object object = root;
        if (object instanceof IncludedHeadersRoot) {
            virtualFile = ((IncludedHeadersRoot)root).getVirtualFile();
        } else if (object instanceof RealFramework) {
            virtualFile = ((RealFramework)root).getVirtualFile();
        } else {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!virtualFile2.isValid()) {
            return null;
        }
        DataInputStream dataInputStream = ourFileCacheAttribute.readAttribute(virtualFile2);
        if (dataInputStream != null) {
            object = dataInputStream;
            Throwable throwable = null;
            try {
                DataInputStream it = (DataInputStream)object;
                boolean bl = false;
                ModuleMapFileSymbolPack moduleMapFileSymbolPack = this.deserializeModuleMap(serializer2, root, it);
                return moduleMapFileSymbolPack;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean serializeModuleMap(ModuleMapSerializer serializer2, HeadersSearchRoot root, OutputStream outputStream, ModuleMapFileSymbolPack moduleMap) {
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            ModuleMapLog.LOG.trace("Serialize Module Map for " + (Object)((Object)root));
        }
        Closeable closeable = new DataOutputStream(outputStream);
        Throwable throwable = null;
        try {
            boolean bl;
            DataOutputStream dos = (DataOutputStream)closeable;
            boolean bl2 = false;
            try {
                dos.writeLong(FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion());
                dos.writeLong(this.calculateHashCode(root));
                bl = serializer2.writeModuleMap(dos, moduleMap);
            }
            catch (IOException e) {
                ModuleMapLog.LOG.warn("Failed to serialize Module Map for " + (Object)((Object)root), (Throwable)e);
                bl = false;
            }
            boolean bl3 = bl;
            return bl3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ModuleMapFileSymbolPack deserializeModuleMap(ModuleMapSerializer serializer2, HeadersSearchRoot root, InputStream inputStream) {
        DataInputStream dis;
        Throwable throwable;
        Closeable closeable;
        block14: {
            if (ModuleMapLog.LOG.isTraceEnabled()) {
                ModuleMapLog.LOG.trace("Deserialize Module Map for " + (Object)((Object)root));
            }
            closeable = new DataInputStream(inputStream);
            throwable = null;
            dis = (DataInputStream)closeable;
            boolean bl = false;
            if (dis.available() != 0) break block14;
            ModuleMapFileSymbolPack moduleMapFileSymbolPack = null;
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            return moduleMapFileSymbolPack;
        }
        try {
            if (dis.readLong() != FileSymbolTableSerializationVersion.INSTANCE.getGlobalIndicesVersion()) {
                ModuleMapFileSymbolPack moduleMapFileSymbolPack = null;
                return moduleMapFileSymbolPack;
            }
            if (dis.readLong() != this.calculateHashCode(root)) {
                ModuleMapFileSymbolPack moduleMapFileSymbolPack = null;
                return moduleMapFileSymbolPack;
            }
            ModuleMapFileSymbolPack moduleMapFileSymbolPack = serializer2.readModuleMap(dis, root);
            return moduleMapFileSymbolPack;
        }
        catch (IOException e) {
            ModuleMapFileSymbolPack moduleMapFileSymbolPack;
            try {
                ModuleMapLog.LOG.warn("Failed to deserialize Module Map for " + (Object)((Object)root), (Throwable)e);
                moduleMapFileSymbolPack = null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            return moduleMapFileSymbolPack;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long calculateHashCode(HeadersSearchRoot root) {
        void hash;
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            ModuleMapLog.LOG.trace("Calculate Hash Code for " + (Object)((Object)root));
        }
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        root.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>((Ref.LongRef)hash){
            final /* synthetic */ Ref.LongRef $hash;

            public final boolean execute(@NotNull PsiFileSystemItem element) {
                if (element instanceof OCFile || element instanceof ModuleMapFile) {
                    this.$hash.element += element.getVirtualFile().getTimeStamp();
                }
                return true;
            }
            {
                this.$hash = longRef;
            }
        });
        return hash.element;
    }

    /*
     * WARNING - void declaration
     */
    public ModuleMapDiskCache() {
        void var2_3;
        ModuleMapSerializer[] moduleMapSerializerArray;
        void size$iv;
        int n = PARALLEL_SERIALIZERS;
        ModuleMapDiskCache moduleMapDiskCache = this;
        ModuleMapSerializer[] result$iv = new ModuleMapSerializer[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            ModuleMapSerializer moduleMapSerializer;
            void i$iv;
            void var5_6 = i$iv;
            void var10_9 = i$iv++;
            moduleMapSerializerArray = result$iv;
            boolean bl = false;
            moduleMapSerializerArray[var10_9] = moduleMapSerializer = new ModuleMapSerializer();
        }
        moduleMapSerializerArray = var2_3;
        moduleMapDiskCache.mySerializers = moduleMapSerializerArray;
    }

    static {
        Companion = new Companion(null);
        PARALLEL_SERIALIZERS = Runtime.getRuntime().availableProcessors();
        ourFileCacheAttribute = new FileAttribute(TABLES_KEY_PREFIX, 10, false);
    }

    @JvmStatic
    @NotNull
    public static final ModuleMapDiskCache getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapDiskCache$Companion;", "", "()V", "PARALLEL_SERIALIZERS", "", "TABLES_KEY_PREFIX", "", "ourFileCacheAttribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getInstance", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapDiskCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ModuleMapDiskCache getInstance(@NotNull Project project2) {
            return (ModuleMapDiskCache)ServiceManager.getService((Project)project2, ModuleMapDiskCache.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

