/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBreadcrumbsProvider
implements BreadcrumbsProvider {
    private static final int MAX_CRUMB_LENGTH = 48;
    private static final Language[] ourLanguages = new Language[]{OCLanguage.getInstance()};

    public Language[] getLanguages() {
        if (ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"cidr.show.breadcrumbs")) {
            return ourLanguages;
        }
        return new Language[0];
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        return e instanceof OCCppNamespace || e instanceof OCStruct || e instanceof OCEnum || e instanceof OCUnion || e instanceof OCFunctionDeclaration || e instanceof OCLambdaExpression || e instanceof OCClassDeclarationBase || e instanceof OCMethod;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        String symbolName;
        OCClassDeclaration cls;
        String name2;
        if (e instanceof OCLambdaExpression) {
            if (e.getParent() instanceof OCDeclarator) {
                OCDeclarator declarator = (OCDeclarator)e.getParent();
                return OCBreadcrumbsProvider.prepareCrumb(declarator.getName());
            }
            OCLambdaExpression exprNode = (OCLambdaExpression)e;
            return OCBreadcrumbsProvider.prepareCrumb(OCBreadcrumbsProvider.getLambdaPresentableName(exprNode));
        }
        if (e instanceof OCClassDeclaration && (name2 = (cls = (OCClassDeclaration)e).getName()) != null) {
            return OCBreadcrumbsProvider.prepareCrumb(OCCodeInsightUtil.getClassNameWithCategory(name2, cls.getCategory()));
        }
        if (e instanceof OCNamespaceQualifierOwner) {
            String symbolName2;
            String qualText;
            OCCppNamespaceQualifier qualifier = ((OCNamespaceQualifierOwner)e).getNamespaceQualifier();
            String string = qualText = qualifier != null ? qualifier.getText() : null;
            if (qualText != null && (symbolName2 = OCElementUtil.getSymbolName(e)) != null) {
                return OCBreadcrumbsProvider.prepareCrumb(qualText + OCTokenTypes.COLON2X.getName() + symbolName2);
            }
        }
        if ((symbolName = OCElementUtil.getSymbolName(e)) != null) {
            return OCBreadcrumbsProvider.prepareCrumb(symbolName);
        }
        return "<unnamed>";
    }

    @Nullable
    public Icon getElementIcon(@NotNull PsiElement element) {
        if (element instanceof OCCppNamespace) {
            return OCSymbolKind.NAMESPACE.getIcon();
        }
        if (element instanceof OCStruct) {
            return OCSymbolKind.STRUCT.getIcon();
        }
        if (element instanceof OCEnum) {
            return OCSymbolKind.ENUM.getIcon();
        }
        if (element instanceof OCUnion) {
            return OCSymbolKind.UNION.getIcon();
        }
        if (element instanceof OCFunctionDeclaration) {
            return OCSymbolKind.FUNCTION_DECLARATION.getIcon();
        }
        if (element instanceof OCLambdaExpression) {
            return OCSymbolKind.FUNCTION_DECLARATION.getIcon();
        }
        return null;
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        return null;
    }

    @NotNull
    private static String getLambdaPresentableName(@NotNull OCLambdaExpression lambdaNode) {
        StringBuilder lambdaText = new StringBuilder();
        String introducerText = lambdaNode.getLambdaIntroducer().getText();
        lambdaText.append(introducerText != null ? introducerText : "[]");
        lambdaText.append("(");
        OCParameterList parameterList = lambdaNode.getParameterList();
        if (parameterList != null && !parameterList.isEmpty()) {
            boolean first = true;
            for (OCDeclarator param : parameterList.getParameters()) {
                if (!first) {
                    lambdaText.append(", ");
                }
                OCType paramType = param.getType();
                lambdaText.append(paramType.getName());
                first = false;
            }
        }
        lambdaText.append(")");
        return lambdaText.toString();
    }

    @NotNull
    private static String prepareCrumb(@NotNull String crumb) {
        return OCBreadcrumbsProvider.ensureFits(OCBreadcrumbsProvider.trimWhitespaces(crumb));
    }

    @NotNull
    private static String trimWhitespaces(@NotNull String text) {
        if (StringUtil.containsWhitespaces((CharSequence)text)) {
            StringBuilder sb = new StringBuilder();
            boolean wsFound = false;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) {
                    if (wsFound) continue;
                    sb.append(" ");
                    wsFound = true;
                    continue;
                }
                sb.append(ch);
                wsFound = false;
            }
            return sb.toString();
        }
        return text;
    }

    @NotNull
    private static String ensureFits(@NotNull String text) {
        return StringUtil.shortenTextWithEllipsis((String)text, (int)48, (int)0);
    }
}

