/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoAction<Psi extends PsiElement> {
    @NotNull
    private final SmartPsiElementPointer<Psi> mySource;
    @NotNull
    private String myName;
    @NotNull
    private Icon myIcon;

    public OCGotoAction(@NotNull Psi source, @NotNull String name2, @NotNull Icon icon) {
        this.mySource = SmartPointerManager.getInstance((Project)source.getProject()).createSmartPsiElementPointer(source);
        this.myName = name2;
        this.myIcon = icon;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    protected void setIcon(@NotNull Icon icon) {
        this.myIcon = icon;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    protected void setName(@NotNull String name2) {
        this.myName = name2;
    }

    @Nullable
    public Psi getSource() {
        return (Psi)this.mySource.getElement();
    }

    @Nullable
    public abstract Collection<? extends OCSymbol> getTargets();

    public abstract void navigate(@Nullable MouseEvent var1, @Nullable Editor var2);

    @NotNull
    public String getTooltip(@NotNull PsiElement psiElement) {
        return this.getName();
    }

    protected static class CellRenderer
    extends DefaultPsiElementCellRenderer {
        final GotoTargetHandler.GotoData myGotoData;

        public CellRenderer(GotoTargetHandler.GotoData gotoData) {
            this.myGotoData = gotoData;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
            }
            PsiElementListCellRenderer gotoRenderer = GotoTargetHandler.createRenderer((GotoTargetHandler.GotoData)this.myGotoData, (PsiElement)((PsiElement)value));
            assert (gotoRenderer != null);
            return gotoRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        @NotNull
        public Comparable getComparingObject(PsiElement element) {
            return super.getComparingObject(element).toString() + element.getTextOffset();
        }
    }
}

