/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoActionAsync<Psi extends PsiElement>
extends OCGotoAction<Psi> {
    @NotNull
    private final Function<Psi, Query<? extends OCSymbol>> myQueryProvider;
    private BackgroundUpdaterTask updater = null;

    public OCGotoActionAsync(@NotNull Psi source, @NotNull String name2, @NotNull Icon icon, @NotNull Function<Psi, Query<? extends OCSymbol>> queryProvider) {
        super(source, name2, icon);
        this.myQueryProvider = queryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigate(@Nullable MouseEvent mouseEvent, Editor editor) {
        OCSymbol firstTarget;
        Query query;
        Object source;
        if (this.updater != null) {
            this.updater.cancelTask();
        }
        if ((source = this.getSource()) == null) {
            return;
        }
        Project project2 = source.getProject();
        Query query2 = query = (Query)this.myQueryProvider.fun(source);
        synchronized (query2) {
            firstTarget = (OCSymbol)query.findFirst();
        }
        if (firstTarget == null) {
            return;
        }
        PsiElement firstPsiTarget = firstTarget.locateDefinition(project2);
        if (!(firstPsiTarget instanceof NavigatablePsiElement)) {
            return;
        }
        NavigatablePsiElement[] firstTargets = new NavigatablePsiElement[]{(NavigatablePsiElement)firstPsiTarget};
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, (PsiElement[])firstTargets, Collections.emptyList());
        OCGotoAction.CellRenderer renderer = new OCGotoAction.CellRenderer(gotoData);
        String name2 = this.getName();
        this.updater = this.createGotoAsyncUpdater(project2, name2, (Query<OCSymbol>)query, renderer.getComparator());
        if (mouseEvent != null) {
            PsiElementListNavigator.openTargets((MouseEvent)mouseEvent, (NavigatablePsiElement[])firstTargets, (String)name2, (String)name2, (ListCellRenderer)((Object)renderer), (BackgroundUpdaterTask)this.updater);
        } else {
            PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])firstTargets, (String)name2, (String)name2, (ListCellRenderer)((Object)renderer), (BackgroundUpdaterTask)this.updater);
        }
    }

    @NotNull
    public Function<Psi, Query<? extends OCSymbol>> getQueryProvider() {
        return this.myQueryProvider;
    }

    @NotNull
    protected BackgroundUpdaterTask createGotoAsyncUpdater(@Nullable Project project2, @NotNull String title, @NotNull Query<? extends OCSymbol> targetQuery, @Nullable Comparator<PsiElement> comparator) {
        return new GotoAsyncUpdater(project2, title, targetQuery, comparator);
    }

    @Override
    @Nullable
    public Collection<? extends OCSymbol> getTargets() {
        Object source = this.getSource();
        if (source == null) {
            return null;
        }
        return ((Query)this.myQueryProvider.fun(source)).findAll();
    }

    protected static class GotoAsyncUpdater
    extends BackgroundUpdaterTask {
        @NotNull
        private final Query<? extends OCSymbol> myTargetQuery;

        public GotoAsyncUpdater(@Nullable Project project2, @NotNull String title, @NotNull Query<? extends OCSymbol> targetQuery, @Nullable Comparator<PsiElement> comparator) {
            super(project2, title, comparator);
            this.myTargetQuery = targetQuery;
        }

        public String getCaption(int size) {
            return this.getTitle() + " (" + size + " " + StringUtil.pluralize((String)"element", (int)size) + " found)";
        }

        public void run(@NotNull ProgressIndicator indicator) {
            super.run(indicator);
            Runnable action = () -> {
                Query<? extends OCSymbol> query = this.myTargetQuery;
                synchronized (query) {
                    this.myTargetQuery.forEachAsync(symbol -> {
                        PsiElement element = symbol.locateDefinition(this.myProject);
                        if (element != null) {
                            if (!this.updateComponent(element)) {
                                indicator.cancel();
                            }
                            return !indicator.isCanceled();
                        }
                        return true;
                    });
                }
            };
            Ref result = new Ref((Object)Boolean.FALSE);
            boolean success = ProgressIndicatorUtils.runWithWriteActionPriority(() -> result.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)), (ProgressIndicator)indicator);
            if (!success || !((Boolean)result.get()).booleanValue()) {
                UIUtil.invokeAndWaitIfNeeded(() -> this.myPopup.cancel());
            }
        }

        public void onSuccess() {
            super.onSuccess();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }
    }
}

