/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoByNameContributor
implements GotoClassContributor {
    protected abstract boolean filterSymbol(@NotNull Project var1, @NotNull OCSymbol var2);

    @NotNull
    public String[] getNames(@NotNull Project project2, boolean includeNonProjectItems) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)project2, (Object)false)).booleanValue()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Set<String> allSymbolNames = OCGlobalProjectSymbolsCache.getAllSymbolNames(project2);
        MostlySingularMultiMap<String, OCClassSymbol> allCategories = OCGlobalProjectSymbolsCache.getAllCategories(project2);
        ArrayList<String> result = new ArrayList<String>(allSymbolNames.size() + allCategories.size());
        result.addAll(allSymbolNames);
        allCategories.processAllValues(symbol -> {
            result.add(symbol.getName() + "+" + symbol.getCategoryName());
            return true;
        });
        return ArrayUtil.toStringArray(result);
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name2, String pattern, Project project2, boolean includeNonProjectItems) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)project2, (Object)false)).booleanValue()) {
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        return this.getSymbolsByName(name2, project2, includeNonProjectItems, (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCImplementationSymbol), false);
    }

    public OCSymbolNavigationItem[] getSymbolsByName(@NotNull String name2, @NotNull Project project2, boolean includeNonProjectItems, @NotNull Condition<OCSymbol> condition, boolean isStrict) {
        ArrayList items = new ArrayList();
        HashSet implementations = new HashSet();
        GlobalSearchScope scope = OCSearchScope.getGotoSymbolScope(project2, includeNonProjectItems);
        Processor processor2 = ocSymbol -> {
            if (ocSymbol instanceof OCUsingSymbol) {
                return true;
            }
            if (ocSymbol.getKind().isType() && ocSymbol.isPredeclaration()) {
                return true;
            }
            if (ocSymbol instanceof OCForeignSymbol) {
                return true;
            }
            if (ocSymbol.isSynthetic()) {
                return true;
            }
            if (ocSymbol instanceof OCInterfaceSymbol && implementations.contains(ocSymbol.getPresentableName())) {
                return true;
            }
            VirtualFile file = ocSymbol.getContainingFile();
            if (file != null && this.filterSymbol(project2, (OCSymbol)ocSymbol) && scope.contains(file)) {
                items.add(new OCSymbolNavigationItem((OCSymbol)ocSymbol, project2));
                if (ocSymbol instanceof OCImplementationSymbol) {
                    implementations.add(ocSymbol.getPresentableName());
                }
            }
            return true;
        };
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(processor2, condition, isStrict ? Conditions.alwaysFalse() : Conditions.alwaysTrue());
        int plus = name2.indexOf(43);
        if (plus != -1) {
            String className = name2.substring(0, plus).trim();
            String categoryName = name2.substring(plus + 1).trim();
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, (Processor<? super OCSymbol>)((Processor)symbol -> !(symbol instanceof OCClassSymbol) || !symbol.getName().equals(className) || orderedProcessor.process(symbol)), categoryName);
        } else {
            OCGlobalProjectSymbolsCache.processByQualifiedName(project2, orderedProcessor, name2);
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, orderedProcessor, name2);
        }
        orderedProcessor.finish();
        Object[] result = items.toArray(new OCSymbolNavigationItem[0]);
        Arrays.sort(result);
        return result;
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        OCSymbol symbol = null;
        Project project2 = null;
        if (item instanceof OCSymbolHolderVirtualPsiElement) {
            symbol = (OCSymbol)((OCSymbolHolderVirtualPsiElement)item).getSymbol();
            project2 = ((OCSymbolHolderVirtualPsiElement)item).getProject();
        } else if (item instanceof OCSymbolNavigationItem) {
            symbol = ((OCSymbolNavigationItem)item).getSymbol();
            project2 = ((OCSymbolNavigationItem)item).getProject();
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCResolveContext context;
            OCQualifiedName qualifiedName;
            OCSymbolWithQualifiedName qnSymbol = (OCSymbolWithQualifiedName)symbol;
            if (qnSymbol.getQualifier() == null && (qualifiedName = qnSymbol.getResolvedQualifiedName(context = OCResolveContext.forSymbol(qnSymbol, project2))) != null) {
                return qualifiedName.getFullName(context);
            }
        } else if (symbol != null) {
            return symbol.getPresentableName();
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "::";
    }
}

