/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.navigation.OCGotoActionSync;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoRelatedSymbolActionSync
extends OCGotoActionSync<OCSymbolDeclarator<?>> {
    public OCGotoRelatedSymbolActionSync(@NotNull OCSymbolDeclarator<?> element) {
        super(element, "Go to definition/declaration", CidrLangIcons.AssocFile);
    }

    @NotNull
    protected List<OCSymbol> evaluateTargets(@NotNull OCSymbolDeclarator<?> source) {
        Object symbol = source.getSymbol();
        Project project2 = source.getProject();
        OCSymbol relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol, project2);
        List<OCSymbol> relatedSymbols = symbol instanceof OCStructSymbol ? OCSearchUtil.getRelatedSymbols((OCStructSymbol)symbol, true, project2) : Collections.emptyList();
        this.setName(OCGotoRelatedSymbolActionSync.inferName(symbol, relatedSymbol, relatedSymbols, project2));
        return relatedSymbols.isEmpty() ? Collections.singletonList(relatedSymbol) : relatedSymbols;
    }

    @NotNull
    private static String inferName(@Nullable OCSymbol symbol, @Nullable OCSymbol relatedSymbol, @NotNull List<OCSymbol> relatedSymbols, @NotNull Project project2) {
        StringBuilder name2 = new StringBuilder("Go to ");
        if (!relatedSymbols.isEmpty()) {
            name2.append("definition(s)");
        } else if (symbol != null && relatedSymbol != null) {
            if (relatedSymbol.getKind().isClass()) {
                name2.append(relatedSymbol.getKind().getNameLowercase()).append(" of '").append(relatedSymbol.getName()).append("'");
            } else if (relatedSymbol instanceof OCStructSymbol && relatedSymbol.isPredeclaration()) {
                name2.append("predefinition of ").append(relatedSymbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project2)));
            } else if (relatedSymbol.getKind() == symbol.getKind()) {
                String defOrDecl = relatedSymbol.isDefinition() ? "definition" : "declaration";
                name2.append(defOrDecl).append(" of ").append(relatedSymbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project2)));
            } else {
                name2.append(" related ").append((Object)relatedSymbol.getKind());
            }
        }
        return name2.toString();
    }
}

