/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSwitchToHeaderOrSourceRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        return ContainerUtil.notNullize((List)((List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (List)ReadAction.compute(() -> OCSwitchToHeaderOrSourceRelatedProvider.doGetItems(context)), OCBundle.message("header.source.looking.for.the.best.file", new Object[0]), true, context.getProject())));
    }

    @NotNull
    private static List<GotoRelatedItem> doGetItems(@NotNull PsiElement context) {
        PsiFile file = context.getContainingFile();
        OCFile target = file instanceof OCFile ? ((OCFile)file).getAssociatedFile() : null;
        final NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.findCounterPartInFile(context, target);
        if (counter != null) {
            return Collections.singletonList(new GotoRelatedItem((PsiElement)counter, target != null && target.isHeader() ? "Headers" : "Sources"){

                public void navigate() {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)counter);
                }
            });
        }
        if (target != null) {
            return Collections.singletonList(new GotoRelatedItem((PsiElement)target, target.isHeader() ? "Headers" : "Sources"));
        }
        return Collections.emptyList();
    }

    @Nullable
    private static NavigatablePsiElement getCounterPartInFile(PsiElement psi, OCFile file) {
        OCSymbol target;
        if (!(psi instanceof OCSymbolDeclarator) || psi instanceof OCMethodSelectorPart) {
            return null;
        }
        Project project2 = psi.getProject();
        Object symbol = ((OCSymbolDeclarator)psi).getSymbol();
        OCSymbol oCSymbol = target = symbol != null ? symbol.getAssociatedSymbol(project2) : null;
        if (target != null && (file == null || file.equals(target.getContainingOCFile(project2)))) {
            return (NavigatablePsiElement)target.locateDefinition(project2);
        }
        return null;
    }

    @Nullable
    private static NavigatablePsiElement findCounterPartInFile(PsiElement psi, OCFile file) {
        while (psi != null && !(psi instanceof PsiFile)) {
            NavigatablePsiElement counter = OCSwitchToHeaderOrSourceRelatedProvider.getCounterPartInFile(psi, file);
            if (counter != null) {
                return counter;
            }
            psi = psi.getParent();
        }
        return null;
    }
}

