/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeBuilder;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCContextChangeBuilderImpl
implements OCContextChange,
OCContextChangeBuilder {
    private final int myOffset;
    @NotNull
    private final Map<String, OCMacroSymbol> myDefinitions = new THashMap();
    @NotNull
    private final Set<String> myUndefs = new THashSet();
    @NotNull
    private final List<OCSymbol> mySymbols = new ArrayList<OCSymbol>();
    @NotNull
    private final Set<VirtualFile> myProcessedFiles = new THashSet();

    public OCContextChangeBuilderImpl(int offset) {
        this.myOffset = offset;
    }

    @Override
    public void define(@NotNull String name2, @NotNull OCMacroSymbol macro) {
        this.myUndefs.remove(name2);
        this.myDefinitions.put(name2, macro);
    }

    @Override
    public void undef(@NotNull String name2) {
        this.myDefinitions.remove(name2);
        this.myUndefs.add(name2);
    }

    @Override
    public void addSymbol(@NotNull OCSymbol symbol) {
        this.mySymbols.add(symbol);
    }

    @Override
    public void addProcessedFile(@NotNull VirtualFile file) {
        this.myProcessedFiles.add(file);
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public void apply(@NotNull OCInclusionContext context) {
        for (OCMacroSymbol macro : this.myDefinitions.values()) {
            context.define(macro);
        }
        for (String name2 : this.myUndefs) {
            context.undef(name2);
        }
        context.preprocessFile(null, null, 1, -1, -1, this.mySymbols, null);
        for (VirtualFile file : this.myProcessedFiles) {
            context.addProcessedFile(file);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCContextChangeBuilderImpl builder = (OCContextChangeBuilderImpl)o;
        if (this.myOffset != builder.myOffset) {
            return false;
        }
        if (!this.myDefinitions.equals(builder.myDefinitions)) {
            return false;
        }
        if (!this.myProcessedFiles.equals(builder.myProcessedFiles)) {
            return false;
        }
        if (!this.mySymbols.equals(builder.mySymbols)) {
            return false;
        }
        return this.myUndefs.equals(builder.myUndefs);
    }

    public int hashCode() {
        int result = this.myOffset;
        result = 31 * result + this.myDefinitions.hashCode();
        result = 31 * result + this.myUndefs.hashCode();
        result = 31 * result + this.mySymbols.hashCode();
        result = 31 * result + this.myProcessedFiles.hashCode();
        return result;
    }
}

