/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextChangeSet {
    @NotNull
    private final String myText;
    @NotNull
    private TIntObjectHashMap<OCContextChange> myChangeMap;
    private int myLastOffset;
    private boolean myIsUpdated;
    private boolean myUsingOriginalMap;

    private OCContextChangeSet(@NotNull String text, @NotNull TIntObjectHashMap<OCContextChange> changeMap, boolean isUpdated, int lastOffset, boolean reusingMap) {
        this.myText = text;
        this.myIsUpdated = isUpdated;
        this.myChangeMap = changeMap;
        this.myLastOffset = lastOffset;
        this.myUsingOriginalMap = reusingMap;
    }

    public boolean isUpdated() {
        return this.myIsUpdated;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public OCContextChange getChange(int offsetAfterInclude) {
        if (offsetAfterInclude > this.myLastOffset) {
            return null;
        }
        return (OCContextChange)this.myChangeMap.get(offsetAfterInclude);
    }

    public void setChange(int offsetAfterInclude, @NotNull OCContextChange change) {
        if (this.myUsingOriginalMap) {
            this.myUsingOriginalMap = false;
            this.myChangeMap = this.myChangeMap.clone();
        }
        if (offsetAfterInclude > this.myLastOffset) {
            this.myLastOffset = offsetAfterInclude;
        }
        this.myChangeMap.put(offsetAfterInclude, (Object)change);
        this.myIsUpdated = true;
    }

    @NotNull
    public static OCContextChangeSet reuse(@NotNull String newText, @Nullable OCContextChangeSet from, int validateFrom, int validateTo) {
        int diffOffset;
        if (from == null) {
            return new OCContextChangeSet(newText, (TIntObjectHashMap<OCContextChange>)new TIntObjectHashMap(), true, 0, false);
        }
        if (validateTo < 0) {
            validateTo = newText.length();
        }
        assert (validateFrom >= 0);
        assert (validateTo >= validateFrom && validateTo <= newText.length());
        int oldLastOffset = from.myLastOffset;
        String oldText = from.getText();
        validateTo = Math.min(oldText.length(), Math.min(validateTo, oldLastOffset + 1));
        if (validateTo == (diffOffset = (validateFrom = Math.min(validateTo, Math.min(Math.min(validateFrom, oldText.length()), newText.length()))) + StringUtil.commonPrefixLength((CharSequence)OCContextChangeSet.subSequence(oldText, validateFrom, validateTo), (CharSequence)OCContextChangeSet.subSequence(newText, validateFrom, newText.length())))) {
            return new OCContextChangeSet(newText, from.myChangeMap, false, oldLastOffset, true);
        }
        final int[] loRef = new int[]{0};
        TIntObjectHashMap fromMap = from.myChangeMap.clone();
        fromMap.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<OCContextChange>(){

            public boolean execute(int offset, OCContextChange change) {
                boolean valid;
                boolean bl = valid = change.getOffset() < diffOffset;
                if (valid && loRef[0] < offset) {
                    loRef[0] = offset;
                }
                return valid;
            }
        });
        int lastOffset = loRef[0];
        return new OCContextChangeSet(newText, (TIntObjectHashMap<OCContextChange>)fromMap, true, lastOffset, false);
    }

    @NotNull
    public List<OCContextChange> getChanges() {
        ArrayList<OCContextChange> result = new ArrayList<OCContextChange>();
        this.myChangeMap.forEachValue(object -> {
            result.add((OCContextChange)object);
            return true;
        });
        Collections.sort(result, (o1, o2) -> o1.getOffset() - o2.getOffset());
        return result;
    }

    private static CharSequence subSequence(CharSequence seq, int start, int end) {
        return new CharSequenceSubSequence(seq, start, end);
    }
}

