/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCDefaultModuleResolver
extends OCModuleResolver {
    @Override
    protected boolean processImports(@NotNull OCInclusionContext context, @NotNull List<String> moduleNameParts, @NotNull Processor<VirtualFile> headerProcessor) {
        if (moduleNameParts.isEmpty()) {
            return true;
        }
        if (context.hasRootFile()) {
            Project project2 = context.getProject();
            VirtualFile virtualFile = context.getRootFile().getVirtualFile();
            if (virtualFile != null) {
                ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(project2);
                OCResolveRootAndConfiguration configuration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
                OCResolveConfiguration resolveConfiguration = configuration.getConfiguration();
                if (resolveConfiguration != null) {
                    String moduleName = StringUtil.join(moduleNameParts, (String)".");
                    return ModuleMapResolveService.getInstance(project2).processModules(moduleName, resolveConfiguration, true, false, (Processor<ModuleMapModuleSymbol>)((Processor)module2 -> ContainerUtil.process(moduleMapResolveService.getIncludeHeaders((ModuleMapModuleSymbol)module2, resolveConfiguration), (Processor)headerProcessor)));
                }
                String frameworkName = moduleNameParts.get(0);
                AppleFramework framework = OCIncludeHelpers.getFramework(configuration, frameworkName);
                if (framework != null && moduleNameParts.size() == 1) {
                    return ContainerUtil.process(framework.getPublicHeadersToInclude(), headerProcessor);
                }
            }
        }
        return true;
    }
}

